/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cdn.v1.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.openstack.cdn.v1.domain.Bandwidth;
import com.huawei.openstack4j.openstack.cdn.v1.domain.BandwidthDetail;
import com.huawei.openstack4j.openstack.cdn.v1.domain.DomainConsumption;
import com.huawei.openstack4j.openstack.cdn.v1.domain.DomainSummary;
import com.huawei.openstack4j.openstack.cdn.v1.domain.DomainSummaryDetail;
import com.huawei.openstack4j.openstack.cdn.v1.domain.Flux;
import com.huawei.openstack4j.openstack.cdn.v1.domain.FluxDetail;
import com.huawei.openstack4j.openstack.cdn.v1.exception.ServerCdnErrorResponseException;
import com.huawei.openstack4j.openstack.cdn.v1.internal.BaseCdnServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class StatisticService
extends BaseCdnServices {
    public Flux queryTotalNetworkTraffic(String domainName, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        return this.queryTotalNetworkTraffic(domainName, null, null, enterpriseProjectId);
    }

    public Flux queryTotalNetworkTraffic(String domainName, Long startTime, Long endTime, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainName, (Object)"parameter `domainName` should not be null");
        BaseOpenStackService.Invocation<Flux> fluxInvocation = this.get(Flux.class, this.uri("/statistics/flux", new Object[0])).param("domain_name", domainName);
        if (startTime != null) {
            fluxInvocation = fluxInvocation.param("start_time", startTime);
        }
        if (endTime != null) {
            fluxInvocation = fluxInvocation.param("end_time", endTime);
        }
        if (enterpriseProjectId != null) {
            fluxInvocation = fluxInvocation.param("enterprise_project_id", enterpriseProjectId);
        }
        return fluxInvocation.execute(this.buildExecutionOptions(Flux.class));
    }

    public FluxDetail queryDetailsOfNetworkTraffic(String domainName, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        return this.queryDetailsOfNetworkTraffic(domainName, null, null, null, enterpriseProjectId);
    }

    public FluxDetail queryDetailsOfNetworkTraffic(String domainName, Long startTime, Long endTime, Integer interval, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainName, (Object)"parameter `domainName` should not be null");
        BaseOpenStackService.Invocation<FluxDetail> fluxDetailInvocation = this.get(FluxDetail.class, this.uri("/statistics/flux-detail", new Object[0])).param("domain_name", domainName);
        if (startTime != null) {
            fluxDetailInvocation = fluxDetailInvocation.param("start_time", startTime);
        }
        if (endTime != null) {
            fluxDetailInvocation = fluxDetailInvocation.param("end_time", endTime);
        }
        if (interval != null) {
            fluxDetailInvocation = fluxDetailInvocation.param("interval", interval);
        }
        if (enterpriseProjectId != null) {
            fluxDetailInvocation = fluxDetailInvocation.param("enterprise_project_id", enterpriseProjectId);
        }
        return fluxDetailInvocation.execute(this.buildExecutionOptions(FluxDetail.class));
    }

    public Bandwidth queryPeakBandwidth(String domainName, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        return this.queryPeakBandwidth(domainName, null, null, enterpriseProjectId);
    }

    public Bandwidth queryPeakBandwidth(String domainName, Long startTime, Long endTime, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainName, (Object)"parameter `domainName` should not be null");
        BaseOpenStackService.Invocation<Bandwidth> bandwidthInvocation = this.get(Bandwidth.class, this.uri("/statistics/bandwidth", new Object[0])).param("domain_name", domainName);
        if (startTime != null) {
            bandwidthInvocation = bandwidthInvocation.param("start_time", startTime);
        }
        if (endTime != null) {
            bandwidthInvocation = bandwidthInvocation.param("end_time", endTime);
        }
        if (enterpriseProjectId != null) {
            bandwidthInvocation = bandwidthInvocation.param("enterprise_project_id", enterpriseProjectId);
        }
        return bandwidthInvocation.execute(this.buildExecutionOptions(Bandwidth.class));
    }

    public BandwidthDetail queryDetailsOfNetworkBandwidth(String domainName, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        return this.queryDetailsOfNetworkBandwidth(domainName, null, null, null, enterpriseProjectId);
    }

    public BandwidthDetail queryDetailsOfNetworkBandwidth(String domainName, Long startTime, Long endTime, Integer interval, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainName, (Object)"parameter `domainName` should not be null");
        BaseOpenStackService.Invocation<BandwidthDetail> bandwidthDetailInvocation = this.get(BandwidthDetail.class, this.uri("/statistics/bandwidth-detail", new Object[0])).param("domain_name", domainName);
        if (startTime != null) {
            bandwidthDetailInvocation = bandwidthDetailInvocation.param("start_time", startTime);
        }
        if (endTime != null) {
            bandwidthDetailInvocation = bandwidthDetailInvocation.param("end_time", endTime);
        }
        if (interval != null) {
            bandwidthDetailInvocation = bandwidthDetailInvocation.param("interval", interval);
        }
        if (enterpriseProjectId != null) {
            bandwidthDetailInvocation = bandwidthDetailInvocation.param("enterprise_project_id", enterpriseProjectId);
        }
        return bandwidthDetailInvocation.execute(this.buildExecutionOptions(BandwidthDetail.class));
    }

    public DomainSummary queryConsumptionSummary(String domainName, String statType, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        return this.queryConsumptionSummary(domainName, statType, null, null, null, enterpriseProjectId);
    }

    public DomainSummary queryConsumptionSummary(String domainName, String statType, Long startTime, Long endTime, String serviceArea, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainName, (Object)"parameter `domainName` should not be null");
        Preconditions.checkNotNull((Object)statType, (Object)"parameter `statType` should not be null");
        BaseOpenStackService.Invocation<DomainSummary> domainSummaryInvocation = this.get(DomainSummary.class, this.uri("/statistics/domain-summary", new Object[0])).param("domain_name", domainName).param("stat_type", statType);
        if (startTime != null) {
            domainSummaryInvocation = domainSummaryInvocation.param("start_time", startTime);
        }
        if (endTime != null) {
            domainSummaryInvocation = domainSummaryInvocation.param("end_time", endTime);
        }
        if (serviceArea != null) {
            domainSummaryInvocation = domainSummaryInvocation.param("service_area", serviceArea);
        }
        if (enterpriseProjectId != null) {
            domainSummaryInvocation = domainSummaryInvocation.param("enterprise_project_id", enterpriseProjectId);
        }
        return domainSummaryInvocation.execute(this.buildExecutionOptions(DomainSummary.class));
    }

    public DomainSummaryDetail queryConsumptionSummaryDetails(String domainName, String statType, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        return this.queryConsumptionSummaryDetails(domainName, statType, null, null, null, null, enterpriseProjectId);
    }

    public DomainSummaryDetail queryConsumptionSummaryDetails(String domainName, String statType, Long startTime, Long endTime, String serviceArea, Integer interval, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainName, (Object)"parameter `domainName` should not be null");
        Preconditions.checkNotNull((Object)statType, (Object)"parameter `statType` should not be null");
        BaseOpenStackService.Invocation<DomainSummaryDetail> domainSummaryDetailsInvocation = this.get(DomainSummaryDetail.class, this.uri("/statistics/domain-summary-detail", new Object[0])).param("domain_name", domainName).param("stat_type", statType);
        if (startTime != null) {
            domainSummaryDetailsInvocation = domainSummaryDetailsInvocation.param("start_time", startTime);
        }
        if (endTime != null) {
            domainSummaryDetailsInvocation = domainSummaryDetailsInvocation.param("end_time", endTime);
        }
        if (serviceArea != null) {
            domainSummaryDetailsInvocation = domainSummaryDetailsInvocation.param("service_area", serviceArea);
        }
        if (interval != null) {
            domainSummaryDetailsInvocation = domainSummaryDetailsInvocation.param("interval", interval);
        }
        if (enterpriseProjectId != null) {
            domainSummaryDetailsInvocation = domainSummaryDetailsInvocation.param("enterprise_project_id", enterpriseProjectId);
        }
        return domainSummaryDetailsInvocation.execute(this.buildExecutionOptions(DomainSummaryDetail.class));
    }

    public List<DomainConsumption> queryDomainConsumptions(String domainName, String statType, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        return this.queryDomainConsumptions(domainName, statType, null, null, null, enterpriseProjectId);
    }

    public List<DomainConsumption> queryDomainConsumptions(String domainName, String statType, Long startTime, Long endTime, String serviceArea, String enterpriseProjectId) throws ServerCdnErrorResponseException {
        Preconditions.checkNotNull((Object)domainName, (Object)"parameter `domainName` should not be null");
        Preconditions.checkNotNull((Object)statType, (Object)"parameter `statType` should not be null");
        BaseOpenStackService.Invocation<DomainConsumption.DomainConsumptions> domainConsumptionsInvocation = this.get(DomainConsumption.DomainConsumptions.class, this.uri("/statistics/domain", new Object[0])).param("domain_name", domainName).param("stat_type", statType);
        if (startTime != null) {
            domainConsumptionsInvocation = domainConsumptionsInvocation.param("start_time", startTime);
        }
        if (endTime != null) {
            domainConsumptionsInvocation = domainConsumptionsInvocation.param("end_time", endTime);
        }
        if (serviceArea != null) {
            domainConsumptionsInvocation = domainConsumptionsInvocation.param("service_area", serviceArea);
        }
        if (enterpriseProjectId != null) {
            domainConsumptionsInvocation = domainConsumptionsInvocation.param("enterprise_project_id", enterpriseProjectId);
        }
        return domainConsumptionsInvocation.execute(this.buildExecutionOptions(DomainConsumption.DomainConsumptions.class)).getDomainConsumptions();
    }
}

