/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.api.client.CloudProvider;
import com.huawei.openstack4j.api.client.IOSClientBuilder;
import com.huawei.openstack4j.api.exceptions.AuthenticationException;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.core.transport.Config;
import com.huawei.openstack4j.model.common.Identifier;
import com.huawei.openstack4j.openstack.common.Auth;
import com.huawei.openstack4j.openstack.identity.v2.domain.Credentials;
import com.huawei.openstack4j.openstack.identity.v2.domain.RaxApiKeyCredentials;
import com.huawei.openstack4j.openstack.identity.v2.domain.TokenAuth;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneAuth;
import com.huawei.openstack4j.openstack.internal.OSAuthenticator;
import com.huawei.openstack4j.openstack.internal.OSClientSessionAKSK;
import com.huawei.openstack4j.openstack.internal.OSClientSessionTempAKSK;

public abstract class OSClientBuilder<R, T extends IOSClientBuilder<R, T>>
implements IOSClientBuilder<R, T> {
    Config config;
    String endpoint;
    String user;
    String password;
    Facing perspective;
    CloudProvider provider = CloudProvider.UNKNOWN;

    @Override
    public T withConfig(Config config) {
        this.config = config;
        return (T)this;
    }

    @Override
    public T provider(CloudProvider provider) {
        this.provider = provider;
        return (T)this;
    }

    @Override
    public T credentials(String user, String password) {
        this.user = user;
        this.password = password;
        return (T)this;
    }

    @Override
    public T endpoint(String endpoint) {
        this.endpoint = endpoint;
        return (T)this;
    }

    @Override
    public T perspective(Facing perspective) {
        this.perspective = perspective;
        return (T)this;
    }

    @Override
    public T useNonStrictSSLClient(boolean useNonStrictSSL) {
        if (this.config == null) {
            this.config = Config.newConfig().withSSLVerificationDisabled();
        }
        return (T)this;
    }

    public static class ClientTempAKSK
    extends OSClientBuilder<OSClient.OSClientTempAKSK, IOSClientBuilder.TempAKSK>
    implements IOSClientBuilder.TempAKSK {
        private String accessKey;
        private String secretKey;
        private String cloudDomainName;
        private String projectId;
        private String region;
        private String domainId;
        private String securityToken;

        @Override
        public OSClient.OSClientTempAKSK authenticate() throws AuthenticationException {
            OSClient.OSClientTempAKSK session = null;
            session = !Strings.isNullOrEmpty((String)this.domainId) ? ((OSClient.OSClientTempAKSK)new OSClientSessionTempAKSK().credentials(this.accessKey, this.secretKey, this.region, this.projectId, this.domainId, this.cloudDomainName, this.securityToken).perspective(this.perspective)).useConfig(this.config) : (!Strings.isNullOrEmpty((String)this.projectId) ? ((OSClient.OSClientTempAKSK)new OSClientSessionTempAKSK().credentials(this.accessKey, this.secretKey, this.region, this.projectId, this.cloudDomainName, this.securityToken).perspective(this.perspective)).useConfig(this.config) : ((OSClient.OSClientTempAKSK)new OSClientSessionTempAKSK().credentials(this.accessKey, this.secretKey, this.region, this.cloudDomainName, this.securityToken).perspective(this.perspective)).useConfig(this.config));
            return session;
        }

        @Override
        public IOSClientBuilder.TempAKSK credentials(String accessKey, String secretKey, String region, String projectId, String cloudDomainName, String securityToken) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"parameter `projectId` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `cloudDomainName` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityToken) ? 1 : 0) != 0, (Object)"parameter `securityToken` should not be empty");
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.cloudDomainName = cloudDomainName;
            this.projectId = projectId;
            this.region = region;
            this.securityToken = securityToken;
            return this;
        }

        @Override
        public IOSClientBuilder.TempAKSK credentials(String accessKey, String secretKey, String region, String cloudDomainName, String securityToken) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `cloudDomainName` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityToken) ? 1 : 0) != 0, (Object)"parameter `securityToken` should not be empty");
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.cloudDomainName = cloudDomainName;
            this.region = region;
            this.securityToken = securityToken;
            return this;
        }

        @Override
        public IOSClientBuilder.TempAKSK credentials(String accessKey, String secretKey, String region, String projectId, String domainId, String cloudDomainName, String securityToken) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `domain` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domainId) ? 1 : 0) != 0, (Object)"parameter `domainId` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)securityToken) ? 1 : 0) != 0, (Object)"parameter `securityToken` should not be empty");
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.cloudDomainName = cloudDomainName;
            this.region = region;
            this.domainId = domainId;
            this.projectId = projectId;
            this.securityToken = securityToken;
            return this;
        }
    }

    public static class ClientAKSK
    extends OSClientBuilder<OSClient.OSClientAKSK, IOSClientBuilder.AKSK>
    implements IOSClientBuilder.AKSK {
        private String accessKey;
        private String secretKey;
        private String cloudDomainName;
        private String projectId;
        private String region;
        private String domainId;

        @Override
        public OSClient.OSClientAKSK authenticate() throws AuthenticationException {
            OSClient.OSClientAKSK session = null;
            session = !Strings.isNullOrEmpty((String)this.domainId) ? ((OSClient.OSClientAKSK)new OSClientSessionAKSK().perspective(this.perspective)).useConfig(this.config).credentials(this.accessKey, this.secretKey, this.region, this.projectId, this.domainId, this.cloudDomainName) : (!Strings.isNullOrEmpty((String)this.projectId) ? ((OSClient.OSClientAKSK)new OSClientSessionAKSK().perspective(this.perspective)).useConfig(this.config).credentials(this.accessKey, this.secretKey, this.region, this.projectId, this.cloudDomainName) : ((OSClient.OSClientAKSK)new OSClientSessionAKSK().perspective(this.perspective)).useConfig(this.config).credentials(this.accessKey, this.secretKey, this.region, this.cloudDomainName));
            return session;
        }

        @Override
        public IOSClientBuilder.AKSK credentials(String accessKey, String secretKey, String region, String projectId, String cloudDomainName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)projectId) ? 1 : 0) != 0, (Object)"parameter `projectId` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `cloudDomainName` should not be empty");
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.cloudDomainName = cloudDomainName;
            this.projectId = projectId;
            this.region = region;
            return this;
        }

        @Override
        public IOSClientBuilder.AKSK credentials(String accessKey, String secretKey, String region, String cloudDomainName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `cloudDomainName` should not be empty");
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.cloudDomainName = cloudDomainName;
            this.region = region;
            return this;
        }

        @Override
        public IOSClientBuilder.AKSK credentials(String accessKey, String secretKey, String region, String projectId, String domainId, String cloudDomainName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)accessKey) ? 1 : 0) != 0, (Object)"parameter `accessKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)secretKey) ? 1 : 0) != 0, (Object)"parameter `secretKey` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)region) ? 1 : 0) != 0, (Object)"parameter `region` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)cloudDomainName) ? 1 : 0) != 0, (Object)"parameter `domain` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)domainId) ? 1 : 0) != 0, (Object)"parameter `domainId` should not be empty");
            this.accessKey = accessKey;
            this.secretKey = secretKey;
            this.cloudDomainName = cloudDomainName;
            this.region = region;
            this.domainId = domainId;
            this.projectId = projectId;
            return this;
        }
    }

    public static class ClientV3
    extends OSClientBuilder<OSClient.OSClientV3, IOSClientBuilder.V3>
    implements IOSClientBuilder.V3 {
        Identifier domain;
        KeystoneAuth.AuthScope scope;
        String tokenId;
        String language;

        @Override
        public ClientV3 domainName(String domainName) {
            this.domain = Identifier.byName(domainName);
            return this;
        }

        @Override
        public ClientV3 domainId(String domainId) {
            this.domain = Identifier.byId(domainId);
            return this;
        }

        @Override
        public ClientV3 credentials(String user, String password, Identifier domain) {
            this.user = user;
            this.password = password;
            this.domain = domain;
            return this;
        }

        @Override
        public ClientV3 token(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        @Override
        public OSClient.OSClientV3 authenticate() throws AuthenticationException {
            if (this.tokenId != null && this.tokenId.length() > 0) {
                return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.tokenId, this.scope), this.endpoint, this.perspective, this.config, this.provider);
            }
            if (this.user != null && this.user.length() > 0) {
                return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.user, this.password, this.domain, this.scope), this.endpoint, this.perspective, this.config, this.provider);
            }
            return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.scope, Auth.Type.TOKENLESS), this.endpoint, this.perspective, this.config, this.provider);
        }

        @Override
        public ClientV3 scopeToProject(Identifier project, Identifier domain) {
            this.scope = KeystoneAuth.AuthScope.project(project, domain);
            return this;
        }

        @Override
        public ClientV3 scopeToProject(Identifier project) {
            this.scope = KeystoneAuth.AuthScope.project(project);
            return this;
        }

        @Override
        public ClientV3 scopeToDomain(Identifier domain) {
            this.scope = KeystoneAuth.AuthScope.domain(domain);
            return this;
        }
    }

    public static class ClientV2
    extends OSClientBuilder<OSClient.OSClientV2, IOSClientBuilder.V2>
    implements IOSClientBuilder.V2 {
        String tenantName;
        String tenantId;
        String tokenId;
        boolean raxApiKey;

        @Override
        public ClientV2 tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        @Override
        public ClientV2 tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @Override
        public ClientV2 raxApiKey(boolean raxApiKey) {
            this.raxApiKey = raxApiKey;
            return this;
        }

        @Override
        public OSClient.OSClientV2 authenticate() throws AuthenticationException {
            if (this.tokenId != null) {
                Preconditions.checkArgument((this.tenantName != null || this.tenantId != null ? 1 : 0) != 0, (Object)"TenantId or TenantName is required when using Token Auth");
                return (OSClient.OSClientV2)OSAuthenticator.invoke(new TokenAuth(this.tokenId, this.tenantName, this.tenantId), this.endpoint, this.perspective, this.config, this.provider);
            }
            if (this.raxApiKey) {
                return (OSClient.OSClientV2)OSAuthenticator.invoke(new RaxApiKeyCredentials(this.user, this.password), this.endpoint, this.perspective, this.config, this.provider);
            }
            return (OSClient.OSClientV2)OSAuthenticator.invoke(new Credentials(this.user, this.password, this.tenantName, this.tenantId), this.endpoint, this.perspective, this.config, this.provider);
        }

        @Override
        public ClientV2 token(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }
    }
}

