/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cloud.trace.v1.domain;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.cloud.trace.constants.TrackerStatus;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

public class Tracker
implements ModelEntity {
    private static final long serialVersionUID = -6764087311133427927L;
    @JsonProperty(value="tracker_name")
    String name;
    @JsonProperty(value="bucket_name")
    String bucketName;
    @JsonProperty(value="file_prefix_name")
    String filePrefixName;
    @JsonProperty(value="status")
    TrackerStatus status;
    @JsonProperty(value="detail")
    String detail;

    public static TrackerBuilder builder() {
        return new TrackerBuilder();
    }

    public TrackerBuilder toBuilder() {
        return new TrackerBuilder().name(this.name).bucketName(this.bucketName).filePrefixName(this.filePrefixName).status(this.status).detail(this.detail);
    }

    public String getName() {
        return this.name;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getFilePrefixName() {
        return this.filePrefixName;
    }

    public TrackerStatus getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public String toString() {
        return "Tracker(name=" + this.getName() + ", bucketName=" + this.getBucketName() + ", filePrefixName=" + this.getFilePrefixName() + ", status=" + (Object)((Object)this.getStatus()) + ", detail=" + this.getDetail() + ")";
    }

    public Tracker() {
    }

    @ConstructorProperties(value={"name", "bucketName", "filePrefixName", "status", "detail"})
    public Tracker(String name, String bucketName, String filePrefixName, TrackerStatus status, String detail) {
        this.name = name;
        this.bucketName = bucketName;
        this.filePrefixName = filePrefixName;
        this.status = status;
        this.detail = detail;
    }

    public static class TrackerBuilder {
        private String name;
        private String bucketName;
        private String filePrefixName;
        private TrackerStatus status;
        private String detail;

        TrackerBuilder() {
        }

        public TrackerBuilder name(String name) {
            this.name = name;
            return this;
        }

        public TrackerBuilder bucketName(String bucketName) {
            this.bucketName = bucketName;
            return this;
        }

        public TrackerBuilder filePrefixName(String filePrefixName) {
            this.filePrefixName = filePrefixName;
            return this;
        }

        public TrackerBuilder status(TrackerStatus status) {
            this.status = status;
            return this;
        }

        public TrackerBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public Tracker build() {
            return new Tracker(this.name, this.bucketName, this.filePrefixName, this.status, this.detail);
        }

        public String toString() {
            return "Tracker.TrackerBuilder(name=" + this.name + ", bucketName=" + this.bucketName + ", filePrefixName=" + this.filePrefixName + ", status=" + (Object)((Object)this.status) + ", detail=" + this.detail + ")";
        }
    }

    public static class Trackers
    extends ListResult<Tracker> {
        private static final long serialVersionUID = 1L;
        private List<Tracker> trackers;

        @Override
        public List<Tracker> value() {
            return this.trackers;
        }

        @JsonCreator
        public Trackers(List<Tracker> trackers) {
            this.trackers = trackers;
        }
    }
}

