/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cloudeye.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.huawei.openstack4j.model.cloudeye.Metric;
import com.huawei.openstack4j.openstack.cloudeye.domain.CloudEyeMetricDemension;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CloudEyeMetric
implements Metric {
    private static final long serialVersionUID = -4166055531397254389L;
    String namespace;
    List<CloudEyeMetricDemension> dimensions;
    @JsonProperty(value="metric_name")
    String metricName;
    String unit;

    @Override
    @JsonIgnore
    public String getId() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.namespace).append(".").append(this.metricName);
        for (CloudEyeMetricDemension dimension : this.dimensions) {
            sb.append(".").append(dimension.getName()).append(":").append(dimension.getValue());
        }
        return sb.toString();
    }

    public static CloudEyeMetricBuilder builder() {
        return new CloudEyeMetricBuilder();
    }

    public CloudEyeMetricBuilder toBuilder() {
        return new CloudEyeMetricBuilder().namespace(this.namespace).dimensions(this.dimensions).metricName(this.metricName).unit(this.unit);
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    public List<CloudEyeMetricDemension> getDimensions() {
        return this.dimensions;
    }

    @Override
    public String getMetricName() {
        return this.metricName;
    }

    @Override
    public String getUnit() {
        return this.unit;
    }

    public String toString() {
        return "CloudEyeMetric(namespace=" + this.getNamespace() + ", dimensions=" + this.getDimensions() + ", metricName=" + this.getMetricName() + ", unit=" + this.getUnit() + ")";
    }

    public CloudEyeMetric() {
    }

    @ConstructorProperties(value={"namespace", "dimensions", "metricName", "unit"})
    public CloudEyeMetric(String namespace, List<CloudEyeMetricDemension> dimensions, String metricName, String unit) {
        this.namespace = namespace;
        this.dimensions = dimensions;
        this.metricName = metricName;
        this.unit = unit;
    }

    public static class CloudEyeMetricBuilder {
        private String namespace;
        private List<CloudEyeMetricDemension> dimensions;
        private String metricName;
        private String unit;

        CloudEyeMetricBuilder() {
        }

        public CloudEyeMetricBuilder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public CloudEyeMetricBuilder dimensions(List<CloudEyeMetricDemension> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        public CloudEyeMetricBuilder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public CloudEyeMetricBuilder unit(String unit) {
            this.unit = unit;
            return this;
        }

        public CloudEyeMetric build() {
            return new CloudEyeMetric(this.namespace, this.dimensions, this.metricName, this.unit);
        }

        public String toString() {
            return "CloudEyeMetric.CloudEyeMetricBuilder(namespace=" + this.namespace + ", dimensions=" + this.dimensions + ", metricName=" + this.metricName + ", unit=" + this.unit + ")";
        }
    }

    public static class CloudEyeMetrics
    extends ListResult<CloudEyeMetric> {
        private static final long serialVersionUID = 2211086062776417518L;
        @JsonProperty(value="metrics")
        protected List<CloudEyeMetric> list;

        @Override
        public List<CloudEyeMetric> value() {
            return this.list;
        }
    }
}

