/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cloudeye.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.cloudeye.AlarmService;
import com.huawei.openstack4j.model.cloudeye.Alarm;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.cloudeye.domain.CloudEyeAlarm;
import com.huawei.openstack4j.openstack.cloudeye.internal.AlarmFilterOptions;
import com.huawei.openstack4j.openstack.cloudeye.internal.BaseCloudEyeServices;
import java.util.HashMap;
import java.util.List;

public class CloudEyeAlarmServiceImpl
extends BaseCloudEyeServices
implements AlarmService {
    @Override
    public List<? extends Alarm> list() {
        return this.get(CloudEyeAlarm.CloudEyeAlarms.class, this.uri("/alarms", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Alarm> list(AlarmFilterOptions options) {
        return this.get(CloudEyeAlarm.CloudEyeAlarms.class, this.uri("/alarms", new Object[0])).params(options.getOptions()).execute().getList();
    }

    @Override
    public Alarm get(String alarmId) {
        Preconditions.checkNotNull((Object)alarmId);
        return (Alarm)this.get(CloudEyeAlarm.CloudEyeAlarms.class, "/alarms", "/", alarmId).execute().getList().get(0);
    }

    @Override
    public ActionResponse startAlarm(String alarmId) {
        Preconditions.checkNotNull((Object)alarmId);
        HashMap<String, Boolean> entity = new HashMap<String, Boolean>();
        entity.put("alarm_enabled", true);
        return this.putWithResponse("/alarms", "/", alarmId, "/action").entity(entity).execute();
    }

    @Override
    public ActionResponse stopAlarm(String alarmId) {
        Preconditions.checkNotNull((Object)alarmId);
        HashMap<String, Boolean> entity = new HashMap<String, Boolean>();
        entity.put("alarm_enabled", false);
        return this.putWithResponse("/alarms", "/", alarmId, "/action").entity(entity).execute();
    }

    @Override
    public ActionResponse deleteAlarm(String alarmId) {
        return this.deleteWithResponse("/alarms", "/", alarmId).execute();
    }
}

