/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.cloudeye.internal;

import com.google.common.collect.Maps;
import com.huawei.openstack4j.model.cloudeye.OrderType;
import java.util.HashMap;
import java.util.Map;

public class MetricFilterOptions {
    private Map<String, Object> queryParams = Maps.newHashMap();

    private MetricFilterOptions() {
    }

    public static MetricFilterOptions create() {
        return new MetricFilterOptions();
    }

    public MetricFilterOptions limit(Integer limit) {
        return this.add("limit", limit);
    }

    public MetricFilterOptions metricName(String metricName) {
        return this.add("metric_name", metricName);
    }

    public MetricFilterOptions start(String start) {
        return this.add("start", start);
    }

    public MetricFilterOptions namespace(String namespace) {
        return this.add("namespace", namespace);
    }

    public MetricFilterOptions order(OrderType orderType) {
        return this.add("order", orderType.value());
    }

    public MetricFilterOptions dim(String[] dimValues) {
        if (dimValues != null) {
            HashMap<String, String> dimsMap = new HashMap<String, String>();
            for (int i = 0; i < dimValues.length; ++i) {
                dimsMap.put("dim." + i, dimValues[i]);
            }
            return this.addAll(dimsMap);
        }
        return this;
    }

    private MetricFilterOptions add(String param, Object value) {
        if (value != null) {
            this.queryParams.put(param, value);
        }
        return this;
    }

    private MetricFilterOptions addAll(Map<String, String> queryValues) {
        if (queryValues != null) {
            this.queryParams.putAll(queryValues);
        }
        return this;
    }

    public Map<String, Object> getOptions() {
        return this.queryParams;
    }
}

