/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.compute.ComputeSecurityGroupService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.compute.SecGroupExtension;
import com.huawei.openstack4j.openstack.compute.domain.NovaSecGroupExtension;
import com.huawei.openstack4j.openstack.compute.internal.BaseComputeServices;
import java.util.List;

public class ComputeSecurityGroupServiceImpl
extends BaseComputeServices
implements ComputeSecurityGroupService {
    @Override
    public List<? extends SecGroupExtension> list() {
        return this.get(NovaSecGroupExtension.SecurityGroups.class, this.uri("/os-security-groups", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends SecGroupExtension> listServerGroups(String serverId) {
        Preconditions.checkNotNull((Object)serverId);
        return this.get(NovaSecGroupExtension.SecurityGroups.class, this.uri("/servers/%s/os-security-groups", serverId)).execute().getList();
    }

    @Override
    public SecGroupExtension get(String securityGroupId) {
        Preconditions.checkNotNull((Object)securityGroupId);
        return this.get(NovaSecGroupExtension.class, this.uri("/os-security-groups/%s", securityGroupId)).execute();
    }

    @Override
    public ActionResponse delete(String securityGroupId) {
        Preconditions.checkNotNull((Object)securityGroupId);
        return this.deleteWithResponse(this.uri("/os-security-groups/%s", securityGroupId)).execute();
    }

    @Override
    public SecGroupExtension create(String name, String description) {
        return this.post(NovaSecGroupExtension.class, this.uri("/os-security-groups", new Object[0])).entity(NovaSecGroupExtension.create(name, description)).execute();
    }

    @Override
    public SecGroupExtension update(String securityGroupId, String name, String description) {
        Preconditions.checkNotNull((Object)securityGroupId);
        Preconditions.checkNotNull((Object)name);
        return this.put(NovaSecGroupExtension.class, this.uri("/os-security-groups/%s", securityGroupId)).entity(NovaSecGroupExtension.create(name, description)).execute();
    }

    @Override
    public SecGroupExtension.Rule createRule(SecGroupExtension.Rule rule) {
        Preconditions.checkNotNull((Object)rule);
        return this.post(NovaSecGroupExtension.SecurityGroupRule.class, this.uri("/os-security-group-rules", new Object[0])).entity(rule).execute();
    }

    @Override
    public ActionResponse deleteRule(String ruleId) {
        Preconditions.checkNotNull((Object)ruleId);
        return this.deleteWithResponse(this.uri("/os-security-group-rules/%s", ruleId)).execute();
    }
}

