/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.compute.HostAggregateService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.compute.HostAggregate;
import com.huawei.openstack4j.openstack.compute.domain.AggregateAddHost;
import com.huawei.openstack4j.openstack.compute.domain.AggregateRemoveHost;
import com.huawei.openstack4j.openstack.compute.domain.HostAggregateMetadata;
import com.huawei.openstack4j.openstack.compute.domain.NovaHostAggregate;
import com.huawei.openstack4j.openstack.compute.domain.NovaHostAggregateCreate;
import com.huawei.openstack4j.openstack.compute.domain.NovaHostAggregateUpdate;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.compute.internal.BaseComputeServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class HostAggregateServiceImpl
extends BaseComputeServices
implements HostAggregateService {
    @Override
    public List<? extends HostAggregate> list() {
        BaseOpenStackService.Invocation<NovaHostAggregate.NovaHostAggregates> req = this.get(NovaHostAggregate.NovaHostAggregates.class, this.uri("/os-aggregates", new Object[0]));
        return req.execute().getList();
    }

    @Override
    public List<? extends HostAggregate> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<NovaHostAggregate.NovaHostAggregates> req = this.get(NovaHostAggregate.NovaHostAggregates.class, this.uri("/os-aggregates", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public NovaHostAggregate get(String aggregateId) {
        Preconditions.checkNotNull((Object)aggregateId);
        return this.get(NovaHostAggregate.class, this.uri("/os-aggregates/%s", aggregateId)).execute();
    }

    @Override
    public ActionResponse delete(String aggregateId) {
        Preconditions.checkNotNull((Object)aggregateId);
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/os-aggregates/%s", aggregateId)).executeWithResponse());
    }

    @Override
    public HostAggregate create(String name, String availabilityZone) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)availabilityZone);
        return this.post(NovaHostAggregate.class, this.uri("/os-aggregates", new Object[0])).entity(new NovaHostAggregateCreate(name, availabilityZone)).execute();
    }

    @Override
    public HostAggregate update(String hostAggregateId, String name, @Nullable String availabilityZone) {
        Preconditions.checkNotNull((Object)hostAggregateId);
        Preconditions.checkNotNull((Object)name);
        return this.put(NovaHostAggregate.class, this.uri("/os-aggregates/%s", hostAggregateId)).entity(new NovaHostAggregateUpdate(name, availabilityZone)).execute();
    }

    @Override
    public HostAggregate setMetadata(String hostAggregateId, Map<String, String> metadata) {
        Preconditions.checkNotNull((Object)hostAggregateId);
        Preconditions.checkNotNull(metadata);
        return this.post(NovaHostAggregate.class, this.uri("/os-aggregates/%s/action", hostAggregateId)).entity(new HostAggregateMetadata(metadata)).execute();
    }

    @Override
    public HostAggregate addHost(String hostAggregateId, String host) {
        Preconditions.checkNotNull((Object)hostAggregateId);
        Preconditions.checkNotNull((Object)host);
        return this.post(NovaHostAggregate.class, this.uri("/os-aggregates/%s/action", hostAggregateId)).entity(new AggregateAddHost(host)).execute();
    }

    @Override
    public HostAggregate removeHost(String hostAggregateId, String host) {
        Preconditions.checkNotNull((Object)hostAggregateId);
        Preconditions.checkNotNull((Object)host);
        return this.post(NovaHostAggregate.class, this.uri("/os-aggregates/%s/action", hostAggregateId)).entity(new AggregateRemoveHost(host)).execute();
    }
}

