/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.compute.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.compute.ext.ServicesService;
import com.huawei.openstack4j.model.compute.ext.Service;
import com.huawei.openstack4j.openstack.compute.domain.ext.ExtService;
import com.huawei.openstack4j.openstack.compute.internal.BaseComputeServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.manila.domain.actions.ServiceAction;
import java.util.List;
import java.util.Map;

public class ServicesServiceImpl
extends BaseComputeServices
implements ServicesService {
    @Override
    public List<? extends Service> list() {
        return this.get(ExtService.Services.class, this.uri("/os-services", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Service> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<ExtService.Services> req = this.get(ExtService.Services.class, this.uri("/os-services", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    @Override
    public Service.Status enableService(String binary, String host) {
        Preconditions.checkNotNull((Object)binary);
        Preconditions.checkNotNull((Object)host);
        return this.put(Service.Status.class, this.uri("/os-services/enable", new Object[0])).entity(ServiceAction.enable(binary, host)).execute();
    }

    @Override
    public Service.Status disableService(String binary, String host) {
        Preconditions.checkNotNull((Object)binary);
        Preconditions.checkNotNull((Object)host);
        return this.put(Service.Status.class, this.uri("/os-services/disable", new Object[0])).entity(ServiceAction.disable(binary, host)).execute();
    }
}

