/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.csbs.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.csbs.v1.domain.BackupCount;
import com.huawei.openstack4j.openstack.csbs.v1.domain.CheckPoint;
import com.huawei.openstack4j.openstack.csbs.v1.domain.CheckPointItem;
import com.huawei.openstack4j.openstack.csbs.v1.domain.CheckPointResp;
import com.huawei.openstack4j.openstack.csbs.v1.internal.BaseCloudServerBackupService;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class BackupManagementService
extends BaseCloudServerBackupService {
    public CheckPointItem get(String checkpointItemId) {
        return this.get(CheckPointItem.class, this.uri("/checkpoint_items/", new Object[0]) + checkpointItemId).execute();
    }

    public ActionResponse delete(String providerId, String checkpointId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)checkpointId) ? 1 : 0) != 0, (Object)"parameter `checkpoint_id` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"parameter `providerId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/providers/" + providerId + "/checkpoints/" + checkpointId, new Object[0])).executeWithResponse());
    }

    public ActionResponse delete(String providerId, String checkpointId, String checkpointItemId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)checkpointId) ? 1 : 0) != 0, (Object)"parameter `checkpoint_id` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)checkpointItemId) ? 1 : 0) != 0, (Object)"parameter `checkpointItemId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"parameter `providerId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/providers/" + providerId + "/checkpoints/" + checkpointId, new Object[0])).param("checkpoint_items", checkpointItemId).executeWithResponse());
    }

    public CheckPointResp create(CheckPoint checkPoint, String providerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"parameter `providerId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)checkPoint.getPlanId()) ? 1 : 0) != 0, (Object)"parameter `planId` should not be empty");
        Preconditions.checkArgument((null != checkPoint.getParameters() ? 1 : 0) != 0, (Object)"parameter `checkPointParam` should not be empty");
        return this.post(CheckPointResp.class, this.uri("/providers/%s/checkpoints", providerId)).entity(checkPoint).execute();
    }

    public Integer get() {
        return this.get(BackupCount.class, "/checkpoint_items/count").execute().getCount();
    }

    public Integer get(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<BackupCount> req = this.get(BackupCount.class, this.uri("/checkpoint_items/count", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getCount();
    }

    public List<CheckPointItem> list() {
        return this.get(CheckPointItem.CheckPointItems.class, "/checkpoint_items").execute().getList();
    }

    public List<CheckPointItem> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CheckPointItem.CheckPointItems> req = this.get(CheckPointItem.CheckPointItems.class, this.uri("/checkpoint_items", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }
}

