/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.csbs.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.csbs.v1.domain.CheckProtectable;
import com.huawei.openstack4j.openstack.csbs.v1.domain.CheckProtectableResp;
import com.huawei.openstack4j.openstack.csbs.v1.domain.CheckRestorable;
import com.huawei.openstack4j.openstack.csbs.v1.domain.CheckRestorableResp;
import com.huawei.openstack4j.openstack.csbs.v1.domain.Protect;
import com.huawei.openstack4j.openstack.csbs.v1.domain.ProtectResp;
import com.huawei.openstack4j.openstack.csbs.v1.internal.BaseCloudServerBackupService;

public class BackupResourceService
extends BaseCloudServerBackupService {
    public ProtectResp create(String providerId, String resourceId, Protect protect) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"parameter `providerId` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resourceId) ? 1 : 0) != 0, (Object)"parameter `resourceId` should not be empty");
        return this.post(ProtectResp.class, this.uri("/providers/%s/resources/%s/action", providerId, resourceId)).entity(protect).execute();
    }

    public CheckProtectableResp getProtectable(String providerId, CheckProtectable checkProtectable) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"parameter `providerId` should not be empty");
        return this.post(CheckProtectableResp.class, this.uri("/providers/%s/resources/action", providerId)).entity(checkProtectable).execute();
    }

    public CheckRestorableResp getRestorable(String providerId, CheckRestorable checkRestorable) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)providerId) ? 1 : 0) != 0, (Object)"parameter `providerId` should not be empty");
        return this.post(CheckRestorableResp.class, this.uri("/providers/%s/resources/action", providerId)).entity(checkRestorable).execute();
    }
}

