/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.database.domain.BackupStrategy;
import com.huawei.openstack4j.openstack.database.domain.Datastore;
import com.huawei.openstack4j.openstack.database.domain.HA;
import com.huawei.openstack4j.openstack.database.domain.NIC;
import com.huawei.openstack4j.openstack.database.domain.Volume;
import java.beans.ConstructorProperties;

@JsonRootName(value="instance")
public class DatabaseInstanceCreate
implements ModelEntity {
    static final long serialVersionUID = -7844139328996206764L;
    @JsonProperty(value="datastore")
    Datastore datastore;
    @JsonProperty(value="name")
    String name;
    @JsonProperty(value="flavorRef")
    String flavorRef;
    @JsonProperty(value="volume")
    Volume volume;
    @JsonProperty(value="region")
    String region;
    @JsonProperty(value="availabilityZone")
    String availabilityZone;
    @JsonProperty(value="vpc")
    String vpcId;
    @JsonProperty(value="nics")
    NIC nic;
    @JsonProperty(value="securityGroup")
    IdResourceEntity securityGroup;
    @JsonProperty(value="dbRtPd")
    String rootPassword;
    @JsonProperty(value="ha")
    HA ha;
    @JsonProperty(value="backupStrategy")
    BackupStrategy backupStrategy;
    @JsonProperty(value="replicaOf")
    String replicaOf;

    public static DatabaseInstanceCreateBuilder builder() {
        return new DatabaseInstanceCreateBuilder();
    }

    public DatabaseInstanceCreateBuilder toBuilder() {
        return new DatabaseInstanceCreateBuilder().datastore(this.datastore).name(this.name).flavorRef(this.flavorRef).volume(this.volume).region(this.region).availabilityZone(this.availabilityZone).vpcId(this.vpcId).nic(this.nic).securityGroup(this.securityGroup).rootPassword(this.rootPassword).ha(this.ha).backupStrategy(this.backupStrategy).replicaOf(this.replicaOf);
    }

    public Datastore getDatastore() {
        return this.datastore;
    }

    public String getName() {
        return this.name;
    }

    public String getFlavorRef() {
        return this.flavorRef;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public String getRegion() {
        return this.region;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public NIC getNic() {
        return this.nic;
    }

    public IdResourceEntity getSecurityGroup() {
        return this.securityGroup;
    }

    public String getRootPassword() {
        return this.rootPassword;
    }

    public HA getHa() {
        return this.ha;
    }

    public BackupStrategy getBackupStrategy() {
        return this.backupStrategy;
    }

    public String getReplicaOf() {
        return this.replicaOf;
    }

    public String toString() {
        return "DatabaseInstanceCreate(datastore=" + this.getDatastore() + ", name=" + this.getName() + ", flavorRef=" + this.getFlavorRef() + ", volume=" + this.getVolume() + ", region=" + this.getRegion() + ", availabilityZone=" + this.getAvailabilityZone() + ", vpcId=" + this.getVpcId() + ", nic=" + this.getNic() + ", securityGroup=" + this.getSecurityGroup() + ", rootPassword=" + this.getRootPassword() + ", ha=" + this.getHa() + ", backupStrategy=" + this.getBackupStrategy() + ", replicaOf=" + this.getReplicaOf() + ")";
    }

    public DatabaseInstanceCreate() {
    }

    @ConstructorProperties(value={"datastore", "name", "flavorRef", "volume", "region", "availabilityZone", "vpcId", "nic", "securityGroup", "rootPassword", "ha", "backupStrategy", "replicaOf"})
    public DatabaseInstanceCreate(Datastore datastore, String name, String flavorRef, Volume volume, String region, String availabilityZone, String vpcId, NIC nic, IdResourceEntity securityGroup, String rootPassword, HA ha, BackupStrategy backupStrategy, String replicaOf) {
        this.datastore = datastore;
        this.name = name;
        this.flavorRef = flavorRef;
        this.volume = volume;
        this.region = region;
        this.availabilityZone = availabilityZone;
        this.vpcId = vpcId;
        this.nic = nic;
        this.securityGroup = securityGroup;
        this.rootPassword = rootPassword;
        this.ha = ha;
        this.backupStrategy = backupStrategy;
        this.replicaOf = replicaOf;
    }

    public static class DatabaseInstanceCreateBuilder {
        private Datastore datastore;
        private String name;
        private String flavorRef;
        private Volume volume;
        private String region;
        private String availabilityZone;
        private String vpcId;
        private NIC nic;
        private IdResourceEntity securityGroup;
        private String rootPassword;
        private HA ha;
        private BackupStrategy backupStrategy;
        private String replicaOf;

        DatabaseInstanceCreateBuilder() {
        }

        public DatabaseInstanceCreateBuilder datastore(Datastore datastore) {
            this.datastore = datastore;
            return this;
        }

        public DatabaseInstanceCreateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatabaseInstanceCreateBuilder flavorRef(String flavorRef) {
            this.flavorRef = flavorRef;
            return this;
        }

        public DatabaseInstanceCreateBuilder volume(Volume volume) {
            this.volume = volume;
            return this;
        }

        public DatabaseInstanceCreateBuilder region(String region) {
            this.region = region;
            return this;
        }

        public DatabaseInstanceCreateBuilder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public DatabaseInstanceCreateBuilder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public DatabaseInstanceCreateBuilder nic(NIC nic) {
            this.nic = nic;
            return this;
        }

        public DatabaseInstanceCreateBuilder securityGroup(IdResourceEntity securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public DatabaseInstanceCreateBuilder rootPassword(String rootPassword) {
            this.rootPassword = rootPassword;
            return this;
        }

        public DatabaseInstanceCreateBuilder ha(HA ha) {
            this.ha = ha;
            return this;
        }

        public DatabaseInstanceCreateBuilder backupStrategy(BackupStrategy backupStrategy) {
            this.backupStrategy = backupStrategy;
            return this;
        }

        public DatabaseInstanceCreateBuilder replicaOf(String replicaOf) {
            this.replicaOf = replicaOf;
            return this;
        }

        public DatabaseInstanceCreate build() {
            return new DatabaseInstanceCreate(this.datastore, this.name, this.flavorRef, this.volume, this.region, this.availabilityZone, this.vpcId, this.nic, this.securityGroup, this.rootPassword, this.ha, this.backupStrategy, this.replicaOf);
        }

        public String toString() {
            return "DatabaseInstanceCreate.DatabaseInstanceCreateBuilder(datastore=" + this.datastore + ", name=" + this.name + ", flavorRef=" + this.flavorRef + ", volume=" + this.volume + ", region=" + this.region + ", availabilityZone=" + this.availabilityZone + ", vpcId=" + this.vpcId + ", nic=" + this.nic + ", securityGroup=" + this.securityGroup + ", rootPassword=" + this.rootPassword + ", ha=" + this.ha + ", backupStrategy=" + this.backupStrategy + ", replicaOf=" + this.replicaOf + ")";
        }
    }
}

