/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.beans.ConstructorProperties;
import java.util.List;

@JsonRootName(value="version")
public class DatastoreVersion
implements ModelEntity {
    private static final long serialVersionUID = 4185143839454760141L;
    private String id;
    private String name;
    @JsonProperty(value="datastore")
    private String datastoreId;
    private String image;
    @JsonProperty(value="packages")
    private String packages;
    @JsonProperty(value="active")
    private Boolean isActive;

    public static DatastoreVersionBuilder builder() {
        return new DatastoreVersionBuilder();
    }

    public DatastoreVersionBuilder toBuilder() {
        return new DatastoreVersionBuilder().id(this.id).name(this.name).datastoreId(this.datastoreId).image(this.image).packages(this.packages).isActive(this.isActive);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDatastoreId() {
        return this.datastoreId;
    }

    public String getImage() {
        return this.image;
    }

    public String getPackages() {
        return this.packages;
    }

    public Boolean getIsActive() {
        return this.isActive;
    }

    public String toString() {
        return "DatastoreVersion(id=" + this.getId() + ", name=" + this.getName() + ", datastoreId=" + this.getDatastoreId() + ", image=" + this.getImage() + ", packages=" + this.getPackages() + ", isActive=" + this.getIsActive() + ")";
    }

    public DatastoreVersion() {
    }

    @ConstructorProperties(value={"id", "name", "datastoreId", "image", "packages", "isActive"})
    public DatastoreVersion(String id, String name, String datastoreId, String image, String packages, Boolean isActive) {
        this.id = id;
        this.name = name;
        this.datastoreId = datastoreId;
        this.image = image;
        this.packages = packages;
        this.isActive = isActive;
    }

    public static class DatastoreVersionBuilder {
        private String id;
        private String name;
        private String datastoreId;
        private String image;
        private String packages;
        private Boolean isActive;

        DatastoreVersionBuilder() {
        }

        public DatastoreVersionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public DatastoreVersionBuilder name(String name) {
            this.name = name;
            return this;
        }

        public DatastoreVersionBuilder datastoreId(String datastoreId) {
            this.datastoreId = datastoreId;
            return this;
        }

        public DatastoreVersionBuilder image(String image) {
            this.image = image;
            return this;
        }

        public DatastoreVersionBuilder packages(String packages) {
            this.packages = packages;
            return this;
        }

        public DatastoreVersionBuilder isActive(Boolean isActive) {
            this.isActive = isActive;
            return this;
        }

        public DatastoreVersion build() {
            return new DatastoreVersion(this.id, this.name, this.datastoreId, this.image, this.packages, this.isActive);
        }

        public String toString() {
            return "DatastoreVersion.DatastoreVersionBuilder(id=" + this.id + ", name=" + this.name + ", datastoreId=" + this.datastoreId + ", image=" + this.image + ", packages=" + this.packages + ", isActive=" + this.isActive + ")";
        }
    }

    public static class Versions
    extends ListResult<DatastoreVersion> {
        private static final long serialVersionUID = 7831092478216356910L;
        @JsonProperty(value="dataStores")
        private List<DatastoreVersion> versions;

        @Override
        protected List<DatastoreVersion> value() {
            return this.versions;
        }
    }
}

