/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.database.domain.DatabaseBackup;
import com.huawei.openstack4j.openstack.database.domain.DatabaseBackupCreate;
import com.huawei.openstack4j.openstack.database.domain.DatabaseBackupCreateResponse;
import com.huawei.openstack4j.openstack.database.domain.DatabaseBackupPolicy;
import com.huawei.openstack4j.openstack.database.domain.DatabaseInstance;
import com.huawei.openstack4j.openstack.database.domain.DatabaseInstanceRestore;
import com.huawei.openstack4j.openstack.database.domain.DatabaseRestorePoint;
import com.huawei.openstack4j.openstack.database.internal.BaseDatabaseServices;
import com.huawei.openstack4j.openstack.trove.domain.ExtendParam;
import java.util.ArrayList;
import java.util.List;

public class DatabaseBackupService
extends BaseDatabaseServices {
    public ActionResponse updateBackupPolicy(String instanceId, DatabaseBackupPolicy policy) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        Preconditions.checkArgument((policy != null ? 1 : 0) != 0, (Object)"parameter `policy` should not be null");
        Preconditions.checkArgument((policy.getKeepDay() >= 0 ? 1 : 0) != 0, (Object)"parameter `policy.keepDay` should be great than zero");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)policy.getStartTime()) ? 1 : 0) != 0, (Object)"parameter `policy.startTime` should be great than zero");
        return this.putWithResponse(this.uri("/instances/%s/backups/policy", instanceId)).entity(policy).execute();
    }

    public DatabaseBackupPolicy getBackupPolicy(String instanceId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        return this.get(DatabaseBackupPolicy.class, this.uri("/instances/%s/backups/policy", instanceId)).execute();
    }

    public DatabaseBackupCreateResponse create(DatabaseBackupCreate creation) {
        return this.post(DatabaseBackupCreateResponse.class, "/backups").entity(creation).execute();
    }

    public List<DatabaseBackup> list() {
        return this.get(DatabaseBackup.Backups.class, "/backups").execute().getList();
    }

    public ActionResponse delete(String backupId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)backupId) ? 1 : 0) != 0, (Object)"parameter `backupId` should not be empty");
        return this.deleteWithResponse("/backups/", backupId).execute();
    }

    public List<String> restoreToExistInstance(String restoreToInstanceId, DatabaseRestorePoint restorePoint) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)restoreToInstanceId) ? 1 : 0) != 0, (Object)"parameter `restoreToInstanceId` should not be empty");
        Preconditions.checkArgument((restorePoint != null ? 1 : 0) != 0, (Object)"parameter `restorePoint` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)restorePoint.getBackupRef()) || restorePoint.getRestoreTime() != null ? 1 : 0) != 0, (Object)"parameter `restorePoint.backupRef` and `restorePoint.restoreTime` should not both be null");
        restorePoint = restorePoint.toBuilder().sourceInstanceId(null).build();
        ExtendParam execute = this.post(ExtendParam.class, this.uri("/instances/%s/action", restoreToInstanceId)).entity(restorePoint).execute();
        ArrayList jobIds = Lists.newArrayList();
        for (IdResourceEntity job : execute.getJobs()) {
            jobIds.add(job.getId());
        }
        return jobIds;
    }

    public DatabaseInstance restoreToNewInstance(DatabaseInstanceRestore restore) {
        Preconditions.checkArgument((restore != null ? 1 : 0) != 0, (Object)"parameter `restore` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)restore.getName()) ? 1 : 0) != 0, (Object)"parameter `restore.name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)restore.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `restore.flavorRef` should not be empty");
        Preconditions.checkArgument((restore.getVolume() != null ? 1 : 0) != 0, (Object)"parameter `restore.volume` should not be null");
        Preconditions.checkArgument((restore.getVolume().getSize() != null ? 1 : 0) != 0, (Object)"parameter `restore.volume.size` should not be null");
        Preconditions.checkArgument((restore.getRestorePoint() != null ? 1 : 0) != 0, (Object)"parameter `restore.restorePoint` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)restore.getRestorePoint().getBackupRef()) || restore.getRestorePoint().getRestoreTime() != null ? 1 : 0) != 0, (Object)"parameter `restore.restorePoint.backupRef` and `restore.restorePoint.restoreTime` should not both be null");
        return this.post(DatabaseInstance.class, "/instances").entity(restore).execute();
    }
}

