/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.database.constants.StatementType;
import com.huawei.openstack4j.openstack.database.domain.DatabaseErrorLog;
import com.huawei.openstack4j.openstack.database.domain.DatabaseSlowLog;
import com.huawei.openstack4j.openstack.database.internal.BaseDatabaseServices;
import com.huawei.openstack4j.openstack.database.options.ErrorLogListOptions;
import java.util.List;

public class DatabaseLogService
extends BaseDatabaseServices {
    public List<DatabaseSlowLog> listSlowLogs(String instanceId, StatementType statementType, Integer top) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)instanceId) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        Preconditions.checkArgument((statementType != null ? 1 : 0) != 0, (Object)"parameter `statementType` should not be null");
        Preconditions.checkArgument((top == null || top >= 1 && top <= 50 ? 1 : 0) != 0, (Object)"parameter `top` should be null or between 1 and 50");
        return this.get(DatabaseSlowLog.SlowLogs.class, this.uri("/instances/%s/slowlog", instanceId)).param("sftype", statementType.name()).param("top", top).execute().getList();
    }

    public List<DatabaseErrorLog> listErrorLogs(ErrorLogListOptions options) {
        Preconditions.checkArgument((options != null ? 1 : 0) != 0, (Object)"parameter `options` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)options.getInstanceId()) ? 1 : 0) != 0, (Object)"parameter `options.instanceId` should not be empty");
        Preconditions.checkArgument((options.getOptions().get("startDate") != null ? 1 : 0) != 0, (Object)"parameter `options.startDate` should not be empty");
        Preconditions.checkArgument((options.getOptions().get("endDate") != null ? 1 : 0) != 0, (Object)"parameter `options.endDate` should not be empty");
        return this.get(DatabaseErrorLog.ErrorLogs.class, this.uri("/instances/%s/errorlog", options.getInstanceId())).params(options.getOptions()).execute().getList();
    }
}

