/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.database.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.core.transport.HttpMethod;
import com.huawei.openstack4j.openstack.common.ServiceVersion;
import com.huawei.openstack4j.openstack.common.functions.GetRootOfURL;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class DatabaseServiceVersionService
extends BaseOpenStackService {
    public DatabaseServiceVersionService() {
        super(ServiceType.DATABASE, GetRootOfURL.instance());
    }

    @Override
    protected <R> BaseOpenStackService.Invocation<R> builder(Class<R> returnType, String path, HttpMethod method) {
        return super.builder(returnType, path, method).header("Content-Type", CONTENT_JSON);
    }

    public List<ServiceVersion> list() {
        return this.get(ServiceVersion.ServiceVersions.class, "/rds/").execute().getList();
    }

    public ServiceVersion get(String versionId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)versionId) ? 1 : 0) != 0, (Object)"parameter `versionId` should not be empty");
        return this.get(ServiceVersion.ServiceVersionWrap.class, "/rds/" + versionId).execute().getVersion();
    }
}

