/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.deh.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.api.deh.DedicatedHostService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.compute.Server;
import com.huawei.openstack4j.openstack.compute.domain.NovaServer;
import com.huawei.openstack4j.openstack.compute.functions.ToActionResponseFunction;
import com.huawei.openstack4j.openstack.deh.domain.DedicatedHost;
import com.huawei.openstack4j.openstack.deh.domain.DedicatedHostCreate;
import com.huawei.openstack4j.openstack.deh.domain.DedicatedHostIds;
import com.huawei.openstack4j.openstack.deh.domain.DedicatedHostType;
import com.huawei.openstack4j.openstack.deh.domain.DedicatedHostUpdate;
import com.huawei.openstack4j.openstack.deh.internal.BaseDehServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DedicatedHostServiceImpl
extends BaseDehServices
implements DedicatedHostService {
    private static final String API_PATH = "/dedicated-hosts";
    private static final String AZ_PATH = "/availability-zone";
    private static final String HOSTTYPE_PATH = "/dedicated-host-types";

    @Override
    public List<String> create(DedicatedHostCreate host) {
        return this.post(DedicatedHostIds.class, this.uri(API_PATH, new Object[0])).entity(host).execute().getList();
    }

    @Override
    public DedicatedHost.DedicatedHosts list() {
        return this.get(DedicatedHost.DedicatedHosts.class, this.uri(API_PATH, new Object[0])).execute();
    }

    @Override
    public DedicatedHost.DedicatedHosts list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<DedicatedHost.DedicatedHosts> req = this.get(DedicatedHost.DedicatedHosts.class, this.uri(API_PATH, new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute();
    }

    @Override
    public DedicatedHost get(String hostId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)hostId) ? 1 : 0) != 0, (Object)"parameter `hostId` should not be empty");
        return this.get(DedicatedHost.class, this.uri("/dedicated-hosts/%s", hostId)).execute();
    }

    @Override
    public List<? extends Server> list(String hostId, String limit, String marker) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)hostId) ? 1 : 0) != 0, (Object)"parameter `hostId` should not be empty");
        HashMap<String, String> filteringParams = new HashMap<String, String>();
        filteringParams.put("limit", limit);
        filteringParams.put("marker", marker);
        return this.get(NovaServer.Servers.class, this.uri("/dedicated-hosts/%s/servers", hostId)).params(filteringParams).execute().getList();
    }

    @Override
    public ActionResponse update(String hostId, DedicatedHostUpdate dedicatedHostUpdate) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)hostId) ? 1 : 0) != 0, (Object)"parameter `hostId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.put(Void.class, this.uri("/dedicated-hosts/%s", hostId)).entity(dedicatedHostUpdate).executeWithResponse());
    }

    @Override
    public ActionResponse delete(String hostId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)hostId) ? 1 : 0) != 0, (Object)"parameter `hostId` should not be empty");
        return ToActionResponseFunction.INSTANCE.apply(this.delete(Void.class, this.uri("/dedicated-hosts/%s", hostId)).executeWithResponse());
    }

    @Override
    public List<DedicatedHostType> listHostType(String availabilityZone) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)availabilityZone) ? 1 : 0) != 0, (Object)"parameter `availabilityZone` should not be empty");
        return this.get(DedicatedHostType.DedicatedHostTypes.class, this.uri("/availability-zone/%s/dedicated-host-types", availabilityZone)).execute().getList();
    }
}

