/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.dns.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.dns.v2.Status;
import com.huawei.openstack4j.model.dns.v2.Zone;
import com.huawei.openstack4j.model.dns.v2.ZoneType;
import com.huawei.openstack4j.model.dns.v2.builder.ZoneBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class DesignateZone
implements Zone {
    private static final long serialVersionUID = 1L;
    private String id;
    private String name;
    private String description;
    private String email;
    @JsonProperty(value="zone_type")
    private ZoneType type;
    private Integer ttl;
    private String serial;
    private Status status;
    @JsonProperty(value="record_num")
    private Integer recordsAmount;
    @JsonProperty(value="pool_id")
    private String poolId;
    @JsonProperty(value="project_id")
    private String projectId;
    @JsonProperty(value="created_at")
    private String createdAt;
    @JsonProperty(value="update_at")
    private String updateAt;
    private Map<String, String> links;
    private List<String> masters;
    private Router router;
    private List<Router> routers;

    public static ZoneBuilder builder() {
        return new ZoneConcreteBuilder();
    }

    @Override
    public ZoneBuilder toBuilder() {
        return new ZoneConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPoolId() {
        return this.poolId;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public Integer getTTL() {
        return this.ttl;
    }

    @Override
    public String getSerial() {
        return this.serial;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public List<String> getMasters() {
        return this.masters;
    }

    @Override
    public ZoneType getType() {
        return this.type;
    }

    @Override
    public String getCreatedAt() {
        return this.createdAt;
    }

    @Override
    public String getUpdateAt() {
        return this.updateAt;
    }

    @Override
    public Map<String, String> getLinks() {
        return this.links;
    }

    @Override
    public Integer getRecordsAmount() {
        return this.recordsAmount;
    }

    public Router getRouter() {
        return this.router;
    }

    @Override
    public List<Router> getRouters() {
        return this.routers;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.poolId, this.projectId, this.name, this.email, this.ttl, this.serial, this.status, this.description, this.masters, this.type, this.createdAt, this.updateAt});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DesignateZone that = (DesignateZone)DesignateZone.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.poolId, (Object)that.poolId) && Objects.equal((Object)this.projectId, (Object)that.projectId) && Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.email, (Object)that.email) && Objects.equal((Object)this.ttl, (Object)that.ttl) && Objects.equal((Object)this.serial, (Object)that.serial) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal(this.masters, that.masters) && Objects.equal((Object)((Object)this.type), (Object)((Object)that.type)) && Objects.equal((Object)this.createdAt, (Object)that.createdAt) && Objects.equal((Object)this.updateAt, (Object)that.updateAt) && Objects.equal((Object)this.recordsAmount, (Object)that.recordsAmount) && Objects.equal(this.links, that.links);
    }

    public String toString() {
        return "DesignateZone(id=" + this.getId() + ", name=" + this.getName() + ", description=" + this.getDescription() + ", email=" + this.getEmail() + ", type=" + (Object)((Object)this.getType()) + ", ttl=" + this.getTTL() + ", serial=" + this.getSerial() + ", status=" + (Object)((Object)this.getStatus()) + ", recordsAmount=" + this.getRecordsAmount() + ", poolId=" + this.getPoolId() + ", projectId=" + this.getProjectId() + ", createdAt=" + this.getCreatedAt() + ", updateAt=" + this.getUpdateAt() + ", links=" + this.getLinks() + ", masters=" + this.getMasters() + ", router=" + this.getRouter() + ", routers=" + this.getRouters() + ")";
    }

    public static class Router
    implements ModelEntity {
        @JsonProperty(value="router_id")
        protected String id;
        @JsonProperty(value="router_region")
        protected String region;
        protected Status status;

        public Router(String id, String region, Status status) {
            this.id = id;
            this.region = region;
            this.status = status;
        }

        public Router() {
        }

        public String getId() {
            return this.id;
        }

        public String getRegion() {
            return this.region;
        }

        public Status getStatus() {
            return this.status;
        }

        public String toString() {
            return "DesignateZone.Router(id=" + this.getId() + ", region=" + this.getRegion() + ", status=" + (Object)((Object)this.getStatus()) + ")";
        }
    }

    public static class Zones
    extends ListResult<DesignateZone> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="zones")
        protected List<DesignateZone> list;

        @Override
        public List<DesignateZone> value() {
            return this.list;
        }
    }

    public static class ZoneConcreteBuilder
    implements ZoneBuilder {
        DesignateZone model;

        ZoneConcreteBuilder() {
            this(new DesignateZone());
        }

        ZoneConcreteBuilder(DesignateZone model) {
            this.model = model;
        }

        @Override
        public Zone build() {
            return this.model;
        }

        @Override
        public ZoneBuilder from(Zone in) {
            if (in != null) {
                this.model = (DesignateZone)in;
            }
            return this;
        }

        @Override
        public ZoneBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public ZoneBuilder poolId(String poolId) {
            this.model.poolId = poolId;
            return this;
        }

        @Override
        public ZoneBuilder projectId(String projectId) {
            this.model.projectId = projectId;
            return this;
        }

        @Override
        public ZoneBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public ZoneBuilder email(String email) {
            this.model.email = email;
            return this;
        }

        @Override
        public ZoneBuilder ttl(Integer ttl) {
            this.model.ttl = ttl;
            return this;
        }

        @Override
        public ZoneBuilder serial(String serial) {
            this.model.serial = serial;
            return this;
        }

        @Override
        public ZoneBuilder status(Status status) {
            this.model.status = status;
            return this;
        }

        @Override
        public ZoneBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public ZoneBuilder masters(List<String> masters) {
            this.model.masters = masters;
            return this;
        }

        @Override
        public ZoneBuilder type(ZoneType type) {
            this.model.type = type;
            return this;
        }

        @Override
        public ZoneBuilder createdAt(String createdAt) {
            this.model.createdAt = createdAt;
            return this;
        }

        @Override
        public ZoneBuilder updatedAt(String updatedAt) {
            this.model.updateAt = updatedAt;
            return this;
        }

        @Override
        public ZoneBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public ZoneBuilder router(Router router) {
            this.model.router = router;
            return this;
        }
    }
}

