/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.dns.v2.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.dns.v2.PTRService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.dns.v2.PTR;
import com.huawei.openstack4j.openstack.dns.v2.domain.DesignatePTR;
import com.huawei.openstack4j.openstack.dns.v2.internal.BaseDNSServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class PTRServiceImpl
extends BaseDNSServices
implements PTRService {
    @Override
    public DesignatePTR setup(DesignatePTR record) {
        Preconditions.checkNotNull((Object)record, (Object)"The PTR record is Null.");
        Preconditions.checkNotNull((Object)record.getPtrdname());
        Preconditions.checkArgument((record.getTtl() >= 300 && record.getTtl() <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"TTL value shold equal or bigger than 300, and equal or less than 2147483647");
        return this.patch(DesignatePTR.class, "/reverse/floatingips", "/", record.getRegion(), ":", record.getFloatingIpId()).entity(record).execute();
    }

    @Override
    public DesignatePTR get(String region, String floatingIpId) {
        Preconditions.checkNotNull((Object)region, (Object)"The region info is Null.");
        Preconditions.checkNotNull((Object)floatingIpId, (Object)"The floating Ip ID is Null.");
        return this.get(DesignatePTR.class, "/reverse/floatingips", "/", region, ":", floatingIpId).execute();
    }

    @Override
    public List<? extends PTR> list() {
        return this.get(DesignatePTR.PTRList.class, this.uri("/reverse/floatingips", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends PTR> list(Map<String, Object> filters) {
        BaseOpenStackService.Invocation<DesignatePTR.PTRList> invocation = this.get(DesignatePTR.PTRList.class, this.uri("/reverse/floatingips", new Object[0]));
        invocation.params(filters);
        return invocation.execute().getList();
    }

    @Override
    public ActionResponse restore(String region, String floatingIpId) {
        Preconditions.checkNotNull((Object)region, (Object)"The region is Null.");
        Preconditions.checkNotNull((Object)floatingIpId, (Object)"The floating Ip Id is Null.");
        DesignatePTR.DesignatePTRBuilder builder = DesignatePTR.builder().ptrdname(null);
        DesignatePTR ptrRecord = builder.build();
        return this.patchWithResponse("/reverse/floatingips", "/", region, ":", floatingIpId).entity(ptrRecord).execute();
    }
}

