/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.dns.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.huawei.openstack4j.api.dns.v2.ZoneService;
import com.huawei.openstack4j.model.dns.v2.Nameserver;
import com.huawei.openstack4j.model.dns.v2.Zone;
import com.huawei.openstack4j.model.dns.v2.ZoneType;
import com.huawei.openstack4j.openstack.dns.v2.domain.DesignateNameserver;
import com.huawei.openstack4j.openstack.dns.v2.domain.DesignateZone;
import com.huawei.openstack4j.openstack.dns.v2.internal.BaseDNSServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.HashMap;
import java.util.List;

public class ZoneServiceImpl
extends BaseDNSServices
implements ZoneService {
    @Override
    public Zone get(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"The zone id is Null.");
        return this.get(DesignateZone.class, "/zones", "/", zoneId).execute();
    }

    @Override
    public Zone delete(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"The zone id is Null.");
        return this.delete(DesignateZone.class, "/zones", "/", zoneId).execute();
    }

    @Override
    public List<? extends Nameserver> listNameservers(String zoneId) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"The zone id is Null.");
        return this.get(DesignateNameserver.Nameservers.class, "/zones", "/", zoneId, "/nameservers").execute().getList();
    }

    @Override
    public Zone create(Zone zone) {
        Preconditions.checkNotNull((Object)zone, (Object)"The Zone record is Null.");
        Preconditions.checkNotNull((Object)zone.getName(), (Object)"The zone record's name properity is Null.");
        Preconditions.checkArgument((boolean)this.checkNameLength(zone.getName()), (Object)this.errorMessageForNameLength(zone.getName()));
        Preconditions.checkArgument((boolean)(zone.getDescription() != null ? zone.getDescription().length() <= 255 : true), (Object)"The description's length is longer than 255");
        Preconditions.checkArgument((boolean)(zone.getTTL() != null ? zone.getTTL() >= 300 && zone.getTTL() <= Integer.MAX_VALUE : true), (Object)"TTL value shold equal or bigger than 300, and equal or less than 2147483647");
        Preconditions.checkArgument((boolean)(zone.getType() == ZoneType.PRIVATE ? ((DesignateZone)zone).getRouter() != null : true), (Object)"The router should not be empty in the private zone");
        return this.post(DesignateZone.class, this.uri("/zones", new Object[0])).entity(zone).execute();
    }

    @Override
    public Zone create(String name, String email) {
        return this.create((Zone)DesignateZone.builder().name(name).email(email).build());
    }

    private boolean checkNameLength(String name) {
        return name.endsWith(".") ? name.length() <= 254 : name.length() <= 253;
    }

    private String errorMessageForNameLength(String name) {
        if (name.endsWith(".")) {
            if (name.length() > 254) {
                return "The name end with dot, its length should not longer than 254";
            }
        } else if (name.length() > 253) {
            return "The name doesn't end with dot, its length should not longer than 253";
        }
        return "";
    }

    @Override
    public List<? extends Zone> list() {
        return this.get(DesignateZone.Zones.class, this.uri("/zones", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Zone> list(ZoneType type, String marker, Integer limit) {
        BaseOpenStackService.Invocation<DesignateZone.Zones> invocation = this.get(DesignateZone.Zones.class, this.uri("/zones", new Object[0]));
        invocation.param("type", type == null ? null : type.name().toLowerCase());
        invocation.param("marker", marker);
        invocation.param("limit", limit);
        return invocation.execute().getList();
    }

    @Override
    public DesignateZone.Router associateRouter(String zoneId, DesignateZone.Router router) {
        this.verifyParameters(zoneId, router);
        HashMap entity = Maps.newHashMap();
        entity.put("router", router);
        return this.post(DesignateZone.Router.class, this.uri("/zones", new Object[0]), "/", zoneId, "/associaterouter").entity(entity).execute();
    }

    @Override
    public DesignateZone.Router disassociateRouter(String zoneId, DesignateZone.Router router) {
        this.verifyParameters(zoneId, router);
        HashMap entity = Maps.newHashMap();
        entity.put("router", router);
        return this.post(DesignateZone.Router.class, this.uri("/zones", new Object[0]), "/", zoneId, "/disassociaterouter").entity(entity).execute();
    }

    private void verifyParameters(String zoneId, DesignateZone.Router router) {
        Preconditions.checkNotNull((Object)zoneId, (Object)"The zone id is Null.");
        Preconditions.checkNotNull((Object)router, (Object)"The router is Null.");
        Preconditions.checkNotNull((Object)router.getId(), (Object)"The router's id is Null.");
        Preconditions.checkNotNull((Object)router.getRegion(), (Object)"The router's region is Null.");
    }
}

