/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.ecs.v1.internal;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.compute.RebootType;
import com.huawei.openstack4j.model.compute.StopType;
import com.huawei.openstack4j.openstack.common.AsyncJobEntity;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.ecs.v1.domain.AsyncServerRespEntity;
import com.huawei.openstack4j.openstack.ecs.v1.domain.CloudAbsoluteLimit;
import com.huawei.openstack4j.openstack.ecs.v1.domain.CloudServer;
import com.huawei.openstack4j.openstack.ecs.v1.domain.Flavor;
import com.huawei.openstack4j.openstack.ecs.v1.domain.ResizeServer;
import com.huawei.openstack4j.openstack.ecs.v1.domain.ServerCreate;
import com.huawei.openstack4j.openstack.ecs.v1.domain.SupportAutoRecovery;
import com.huawei.openstack4j.openstack.ecs.v1.internal.BaseElasticComputeServices;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class CloudServerService
extends BaseElasticComputeServices {
    public String create(ServerCreate creation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getImageRef()) ? 1 : 0) != 0, (Object)"parameter `imageRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getVpcId()) ? 1 : 0) != 0, (Object)"parameter `vpcid` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getAvailabilityZone()) ? 1 : 0) != 0, (Object)"parameter `availability_zone` should not be empty");
        Preconditions.checkArgument((creation.getPersonality() == null || creation.getPersonality().size() <= 5 ? 1 : 0) != 0, (Object)"size of parameter `personality` should not greate than 5");
        Preconditions.checkArgument((creation.getNetworks() != null && creation.getNetworks().size() > 0 ? 1 : 0) != 0, (Object)"parameter `networks` should not be empty");
        Preconditions.checkArgument((creation.getRootVolume() != null ? 1 : 0) != 0, (Object)"parameter `root_volume` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudservers").entity(creation).execute().getId();
    }

    public AsyncServerRespEntity createServer(ServerCreate creation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getImageRef()) ? 1 : 0) != 0, (Object)"parameter `imageRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getVpcId()) ? 1 : 0) != 0, (Object)"parameter `vpcid` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getAvailabilityZone()) ? 1 : 0) != 0, (Object)"parameter `availability_zone` should not be empty");
        Preconditions.checkArgument((creation.getNetworks() != null && creation.getNetworks().size() > 0 ? 1 : 0) != 0, (Object)"parameter `networks` should not be empty");
        Preconditions.checkArgument((creation.getRootVolume() != null ? 1 : 0) != 0, (Object)"parameter `root_volume` should not be empty");
        return this.post(AsyncServerRespEntity.class, "/cloudservers").entity(creation).execute();
    }

    public String delete(List<String> serverIds, boolean deletePublicIp, boolean deleteVolume) {
        Preconditions.checkArgument((serverIds != null && serverIds.size() > 0 ? 1 : 0) != 0, (Object)"parameter `serverIds` should not be empty");
        DeleteServerRequest request = new DeleteServerRequest(serverIds, deletePublicIp, deleteVolume);
        return this.post(AsyncJobEntity.class, this.uri("/cloudservers/delete", new Object[0])).entity(request).execute().getId();
    }

    public String stop(List<String> serverIds, StopType type) {
        Preconditions.checkArgument((serverIds != null && serverIds.size() > 0 ? 1 : 0) != 0, (Object)"parameter `serverIds` should not be empty");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"parameter `type` should not be null");
        BatchStopAction action = new BatchStopAction(serverIds, type);
        return this.post(AsyncJobEntity.class, this.uri("/cloudservers/action", new Object[0])).entity(action).execute().getId();
    }

    public String reboot(List<String> serverIds, RebootType type) {
        Preconditions.checkArgument((serverIds != null && serverIds.size() > 0 ? 1 : 0) != 0, (Object)"parameter `serverIds` should not be empty");
        Preconditions.checkArgument((type != null ? 1 : 0) != 0, (Object)"parameter `type` should not be null");
        BatchRebootAction action = new BatchRebootAction(serverIds, type);
        return this.post(AsyncJobEntity.class, this.uri("/cloudservers/action", new Object[0])).entity(action).execute().getId();
    }

    public String start(List<String> serverIds) {
        Preconditions.checkArgument((serverIds != null && serverIds.size() > 0 ? 1 : 0) != 0, (Object)"parameter `serverIds` should not be empty");
        BatchStartAction action = new BatchStartAction(serverIds);
        return this.post(AsyncJobEntity.class, this.uri("/cloudservers/action", new Object[0])).entity(action).execute().getId();
    }

    public String resize(ResizeServer resize, String serverId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resize.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudservers/" + serverId + "/resize").entity(resize).execute().getId();
    }

    public List<CloudServer> list() {
        return this.get(CloudServer.CloudServers.class, this.uri("/cloudservers/detail", new Object[0])).execute().getList();
    }

    public List<CloudServer> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CloudServer.CloudServers> serverInvocation = this.get(CloudServer.CloudServers.class, "/cloudservers/detail");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute().getList();
    }

    public CloudServer.CloudServers listWithCount() {
        return this.get(CloudServer.CloudServers.class, this.uri("/cloudservers/detail", new Object[0])).execute();
    }

    public CloudServer.CloudServers listWithCount(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<CloudServer.CloudServers> serverInvocation = this.get(CloudServer.CloudServers.class, "/cloudservers/detail");
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                serverInvocation = serverInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return serverInvocation.execute();
    }

    public CloudServer get(String serverId) {
        return this.get(CloudServer.class, this.uri("/cloudservers/", new Object[0]) + serverId).execute();
    }

    public List<Flavor> getSpecifications(String availabilityZone) {
        return this.get(Flavor.Flavors.class, this.uri("/cloudservers/flavors", new Object[0])).param("availability_zone", availabilityZone).execute().getList();
    }

    public CloudAbsoluteLimit limits() {
        return this.get(CloudAbsoluteLimit.class, this.uri("/cloudservers/limits", new Object[0])).execute();
    }

    public SupportAutoRecovery getAutoRecovery(String serverId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverId) ? 1 : 0) != 0, (Object)"parameter `serverId` should not be empty");
        return this.get(SupportAutoRecovery.class, this.uri("/cloudservers/" + serverId + "/autorecovery", new Object[0])).execute();
    }

    public ActionResponse manageAutoRecovery(String serverId, SupportAutoRecovery supportAutoRecovery) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serverId) ? 1 : 0) != 0, (Object)"parameter `serverId` should not be empty");
        Preconditions.checkArgument((supportAutoRecovery != null ? 1 : 0) != 0, (Object)"parameter `supportAutoRecovery` should not be empty");
        return this.put(ActionResponse.class, this.uri("/cloudservers/" + serverId + "/autorecovery", new Object[0])).entity(supportAutoRecovery).execute();
    }

    public static class DeleteServerRequest
    implements ModelEntity {
        private static final long serialVersionUID = -3993352728410832732L;
        @JsonProperty(value="delete_publicip")
        public boolean deletePublicIp;
        @JsonProperty(value="delete_volume")
        public boolean deleteVolume;
        @JsonProperty(value="servers")
        List<IdResourceEntity> servers = Lists.newArrayList();

        public DeleteServerRequest(List<String> serverIds, boolean deletePublicIp, boolean deleteVolume) {
            for (String serverId : serverIds) {
                this.servers.add(new IdResourceEntity(serverId));
            }
            this.deletePublicIp = deletePublicIp;
            this.deleteVolume = deleteVolume;
        }
    }

    @JsonRootName(value="os-stop")
    public static class BatchStopAction
    extends BatchAction {
        private static final long serialVersionUID = 9217647120271727241L;

        public BatchStopAction(List<String> serverIds, StopType type) {
            super(serverIds, type.name().toLowerCase());
        }
    }

    @JsonRootName(value="reboot")
    public static class BatchRebootAction
    extends BatchAction {
        private static final long serialVersionUID = 3151059333050510631L;

        public BatchRebootAction(List<String> serverIds, RebootType type) {
            super(serverIds, type.name().toLowerCase());
        }
    }

    @JsonRootName(value="os-start")
    public static class BatchStartAction
    extends BatchAction {
        private static final long serialVersionUID = -8311243025930452903L;

        public BatchStartAction(List<String> serverIds) {
            super(serverIds, null);
        }
    }

    public static class BatchAction
    implements ModelEntity {
        private static final long serialVersionUID = -3993352728410832732L;
        @JsonProperty(value="type")
        public String type;
        @JsonProperty(value="servers")
        List<IdResourceEntity> servers = Lists.newArrayList();

        public BatchAction(List<String> serverIds, String type) {
            for (String serverId : serverIds) {
                this.servers.add(new IdResourceEntity(serverId));
            }
            this.type = type;
        }
    }
}

