/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.ecs.v1_1.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.common.IdResourceEntity;
import com.huawei.openstack4j.openstack.common.ListResult;
import com.huawei.openstack4j.openstack.ecs.v1.domain.Network;
import com.huawei.openstack4j.openstack.ecs.v1.domain.Personality;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.DataVolume;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.FloatingIPCreate;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.PublicIP;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.RootVolume;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.SchedulerHints;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.ServerExtendParam;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.ServerTags;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@JsonRootName(value="server")
public class ServerCreate
implements ModelEntity {
    private static final long serialVersionUID = 190714568493709721L;
    private String name;
    private String imageRef;
    private String flavorRef;
    private List<Personality> personality;
    @JsonProperty(value="user_data")
    private String userData;
    private String adminPass;
    @JsonProperty(value="key_name")
    private String keyName;
    @JsonProperty(value="vpcid")
    private String vpcId;
    @JsonProperty(value="nics")
    private List<Network> networks;
    @JsonProperty(value="publicip")
    private PublicIP publicIP;
    @JsonProperty(value="count")
    private Integer count;
    @JsonProperty(value="root_volume")
    private RootVolume rootVolume;
    @JsonProperty(value="data_volumes")
    private List<DataVolume> dataVolumes;
    @JsonProperty(value="security_groups")
    private List<IdResourceEntity> securityGroups;
    @JsonProperty(value="availability_zone")
    private String availabilityZone;
    @JsonProperty(value="extendparam")
    private ServerExtendParam extendParam;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata;
    @JsonProperty(value="tags")
    private List<String> tags;
    @JsonProperty(value="server_tags")
    private List<ServerTags> serverTags;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="isAutoRename")
    private Boolean isAutoRename;
    @JsonProperty(value="os:scheduler_hints")
    private SchedulerHints schedulerHints;

    @ConstructorProperties(value={"name", "imageRef", "flavorRef", "personality", "userData", "adminPass", "keyName", "vpcId", "networks", "publicIP", "count", "rootVolume", "dataVolumes", "securityGroups", "availabilityZone", "extendParam", "metadata", "tags", "serverTags", "description", "isAutoRename", "schedulerHints"})
    public ServerCreate(String name, String imageRef, String flavorRef, List<Personality> personality, String userData, String adminPass, String keyName, String vpcId, List<Network> networks, PublicIP publicIP, Integer count, RootVolume rootVolume, List<DataVolume> dataVolumes, List<IdResourceEntity> securityGroups, String availabilityZone, ServerExtendParam extendParam, Map<String, Object> metadata, List<String> tags, List<ServerTags> serverTags, String description, SchedulerHints schedulerHints, Boolean isAutoRename) {
        this.name = name;
        this.imageRef = imageRef;
        this.flavorRef = flavorRef;
        this.personality = personality;
        this.userData = userData;
        this.adminPass = adminPass;
        this.keyName = keyName;
        this.vpcId = vpcId;
        this.networks = networks;
        this.publicIP = publicIP;
        this.count = count;
        this.rootVolume = rootVolume;
        this.dataVolumes = dataVolumes;
        this.securityGroups = securityGroups;
        this.availabilityZone = availabilityZone;
        this.extendParam = extendParam;
        this.metadata = metadata;
        this.tags = tags;
        this.serverTags = serverTags;
        this.description = description;
        this.schedulerHints = schedulerHints;
        this.isAutoRename = isAutoRename;
    }

    public ServerCreate() {
    }

    public static ServerCreateBuilder builder() {
        return new ServerCreateBuilder();
    }

    public ServerCreateBuilder toBuilder() {
        return new ServerCreateBuilder().name(this.name).imageRef(this.imageRef).flavorRef(this.flavorRef).personality(this.personality).userData(this.userData).adminPass(this.adminPass).keyName(this.keyName).vpcId(this.vpcId).networks(this.networks).publicIP(this.publicIP).count(this.count).rootVolume(this.rootVolume).dataVolumes(this.dataVolumes).securityGroups(this.securityGroups).availabilityZone(this.availabilityZone).extendParam(this.extendParam).metadata(this.metadata).tags(this.tags).serverTags(this.serverTags).description(this.description);
    }

    public String getName() {
        return this.name;
    }

    public String getImageRef() {
        return this.imageRef;
    }

    public String getFlavorRef() {
        return this.flavorRef;
    }

    public List<Personality> getPersonality() {
        return this.personality;
    }

    public String getUserData() {
        return this.userData;
    }

    public String getAdminPass() {
        return this.adminPass;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getVpcId() {
        return this.vpcId;
    }

    public List<Network> getNetworks() {
        return this.networks;
    }

    public PublicIP getPublicIP() {
        return this.publicIP;
    }

    public Integer getCount() {
        return this.count;
    }

    public RootVolume getRootVolume() {
        return this.rootVolume;
    }

    public List<DataVolume> getDataVolumes() {
        return this.dataVolumes;
    }

    public List<IdResourceEntity> getSecurityGroups() {
        return this.securityGroups;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public ServerExtendParam getExtendParam() {
        return this.extendParam;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public List<ServerTags> getServerTags() {
        return this.serverTags;
    }

    public String getDescription() {
        return this.description;
    }

    public Boolean getIsAutoRename() {
        return this.isAutoRename;
    }

    public SchedulerHints getSchedulerHints() {
        return this.schedulerHints;
    }

    public String toString() {
        return "ServerCreate(name=" + this.getName() + ", imageRef=" + this.getImageRef() + ", flavorRef=" + this.getFlavorRef() + ", personality=" + this.getPersonality() + ", userData=" + this.getUserData() + ", adminPass=" + this.getAdminPass() + ", keyName=" + this.getKeyName() + ", vpcId=" + this.getVpcId() + ", networks=" + this.getNetworks() + ", publicIP=" + this.getPublicIP() + ", count=" + this.getCount() + ", rootVolume=" + this.getRootVolume() + ", dataVolumes=" + this.getDataVolumes() + ", securityGroups=" + this.getSecurityGroups() + ", availabilityZone=" + this.getAvailabilityZone() + ", extendParam=" + this.getExtendParam() + ", metadata=" + this.getMetadata() + ", tags=" + this.getTags() + ", serverTags=" + this.getServerTags() + ", description=" + this.getDescription() + this.getIsAutoRename() + this.getSchedulerHints() + ")";
    }

    public static class ServerCreateBuilder {
        private String name;
        private String imageRef;
        private String flavorRef;
        private List<Personality> personality;
        private String userData;
        private String adminPass;
        private String keyName;
        private String vpcId;
        private List<Network> networks;
        private PublicIP publicIP;
        private Integer count;
        private RootVolume rootVolume;
        private List<DataVolume> dataVolumes;
        private List<IdResourceEntity> securityGroups;
        private String availabilityZone;
        private ServerExtendParam extendParam;
        private Map<String, Object> metadata;
        private List<String> tags;
        private List<ServerTags> serverTags;
        private String description;
        private Boolean isAutoRename;
        private SchedulerHints schedulerHints;

        ServerCreateBuilder() {
        }

        public ServerCreateBuilder name(String name) {
            this.name = name;
            return this;
        }

        public ServerCreateBuilder imageRef(String imageRef) {
            this.imageRef = imageRef;
            return this;
        }

        public ServerCreateBuilder flavorRef(String flavorRef) {
            this.flavorRef = flavorRef;
            return this;
        }

        public ServerCreateBuilder personality(List<Personality> personality) {
            this.personality = personality;
            return this;
        }

        public ServerCreateBuilder addPersonality(Personality personality) {
            if (this.personality == null) {
                this.personality = new ArrayList<Personality>();
            }
            this.personality.add(personality);
            return this;
        }

        public ServerCreateBuilder userData(String userData) {
            this.userData = userData;
            return this;
        }

        public ServerCreateBuilder adminPass(String adminPass) {
            this.adminPass = adminPass;
            return this;
        }

        public ServerCreateBuilder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public ServerCreateBuilder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public ServerCreateBuilder networks(List<Network> networks) {
            this.networks = networks;
            return this;
        }

        public ServerCreateBuilder addNetwork(Network network) {
            if (this.networks == null) {
                this.networks = new ArrayList<Network>();
            }
            this.networks.add(network);
            return this;
        }

        public ServerCreateBuilder addNetwork(String subnetId) {
            this.addNetwork(Network.builder().subnetId(subnetId).build());
            return this;
        }

        public ServerCreateBuilder addNetwork(String subnetId, String ipAddress) {
            Network network = Network.builder().subnetId(subnetId).ipAddress(ipAddress).build();
            this.addNetwork(network);
            return this;
        }

        public ServerCreateBuilder publicIP(PublicIP publicIP) {
            this.publicIP = publicIP;
            return this;
        }

        public ServerCreateBuilder publicIP(String floatingIP) {
            this.publicIP = PublicIP.builder().floatingIP(floatingIP).build();
            return this;
        }

        public ServerCreateBuilder publicIP(FloatingIPCreate eip) {
            this.publicIP = PublicIP.builder().eip(eip).build();
            return this;
        }

        public ServerCreateBuilder count(Integer count) {
            this.count = count;
            return this;
        }

        public ServerCreateBuilder rootVolume(RootVolume rootVolume) {
            this.rootVolume = rootVolume;
            return this;
        }

        public ServerCreateBuilder dataVolumes(List<DataVolume> dataVolumes) {
            this.dataVolumes = dataVolumes;
            return this;
        }

        public ServerCreateBuilder addDataVolume(DataVolume volume) {
            if (this.dataVolumes == null) {
                this.dataVolumes = new ArrayList<DataVolume>();
            }
            this.dataVolumes.add(volume);
            return this;
        }

        public ServerCreateBuilder securityGroups(List<IdResourceEntity> securityGroups) {
            this.securityGroups = securityGroups;
            return this;
        }

        public ServerCreateBuilder addSecurityGroup(String securityGroupId) {
            if (this.securityGroups == null) {
                this.securityGroups = new ArrayList<IdResourceEntity>();
            }
            this.securityGroups.add(new IdResourceEntity(securityGroupId));
            return this;
        }

        public ServerCreateBuilder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public ServerCreateBuilder extendParam(ServerExtendParam extendParam) {
            this.extendParam = extendParam;
            return this;
        }

        public ServerCreateBuilder metadata(Map<String, Object> metadata) {
            this.metadata = metadata;
            return this;
        }

        public ServerCreateBuilder addMetadata(String key, Object value) {
            if (this.metadata == null) {
                this.metadata = new HashMap<String, Object>();
            }
            this.metadata.put(key, value);
            return this;
        }

        public ServerCreateBuilder tags(List<String> tags) {
            this.tags = tags;
            return this;
        }

        public ServerCreateBuilder addTag(String tag) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(tag);
            return this;
        }

        public ServerCreateBuilder addTag(String key, String value) {
            if (this.tags == null) {
                this.tags = new ArrayList<String>();
            }
            this.tags.add(key + "." + value);
            return this;
        }

        public ServerCreateBuilder serverTags(List<ServerTags> serverTags) {
            this.serverTags = serverTags;
            return this;
        }

        public ServerCreateBuilder addServerTag(ServerTags serverTag) {
            if (this.serverTags == null) {
                this.serverTags = new ArrayList<ServerTags>();
            }
            this.serverTags.add(serverTag);
            return this;
        }

        public ServerCreateBuilder description(String description) {
            this.description = description;
            return this;
        }

        public ServerCreateBuilder isAutoRename(Boolean isAutoRename) {
            this.isAutoRename = isAutoRename;
            return this;
        }

        public ServerCreateBuilder schedulerHints(SchedulerHints schedulerHints) {
            this.schedulerHints = schedulerHints;
            return this;
        }

        public ServerCreate build() {
            return new ServerCreate(this.name, this.imageRef, this.flavorRef, this.personality, this.userData, this.adminPass, this.keyName, this.vpcId, this.networks, this.publicIP, this.count, this.rootVolume, this.dataVolumes, this.securityGroups, this.availabilityZone, this.extendParam, this.metadata, this.tags, this.serverTags, this.description, this.schedulerHints, this.isAutoRename);
        }

        public String toString() {
            return "ServerCreate.ServerCreateBuilder(name=" + this.name + ", imageRef=" + this.imageRef + ", flavorRef=" + this.flavorRef + ", personality=" + this.personality + ", userData=" + this.userData + ", adminPass=" + this.adminPass + ", keyName=" + this.keyName + ", vpcId=" + this.vpcId + ", networks=" + this.networks + ", publicIP=" + this.publicIP + ", count=" + this.count + ", rootVolume=" + this.rootVolume + ", dataVolumes=" + this.dataVolumes + ", securityGroups=" + this.securityGroups + ", availabilityZone=" + this.availabilityZone + ", extendParam=" + this.extendParam + ", metadata=" + this.metadata + ", tags=" + this.tags + ", serverTags=" + this.serverTags + ", description=" + this.description + ")";
        }
    }

    public static class ServerCreates
    extends ListResult<ServerCreate> {
        private static final long serialVersionUID = -2458222536946947327L;
        @JsonProperty(value="servers")
        private List<ServerCreate> ServerCreates;

        @Override
        protected List<ServerCreate> value() {
            return this.ServerCreates;
        }
    }
}

