/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.ecs.v1_1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.common.AsyncRespEntity;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.AsyncServerRespEntity;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.ResizeServer;
import com.huawei.openstack4j.openstack.ecs.v1_1.domain.ServerCreate;
import com.huawei.openstack4j.openstack.ecs.v1_1.internal.BaseElasticComputeServices;

public class CloudServerService
extends BaseElasticComputeServices {
    public AsyncServerRespEntity create(ServerCreate creation) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getImageRef()) ? 1 : 0) != 0, (Object)"parameter `imageRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getVpcId()) ? 1 : 0) != 0, (Object)"parameter `vpcid` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)creation.getAvailabilityZone()) ? 1 : 0) != 0, (Object)"parameter `availability_zone` should not be empty");
        Preconditions.checkArgument((creation.getPersonality() == null || creation.getPersonality().size() <= 5 ? 1 : 0) != 0, (Object)"size of parameter `personality` should not greate than 5");
        Preconditions.checkArgument((creation.getNetworks() != null && creation.getNetworks().size() > 0 ? 1 : 0) != 0, (Object)"parameter `networks` should not be empty");
        Preconditions.checkArgument((creation.getRootVolume() != null ? 1 : 0) != 0, (Object)"parameter `root_volume` should not be empty");
        return this.post(AsyncServerRespEntity.class, "/cloudservers").entity(creation).execute();
    }

    public AsyncRespEntity resize(ResizeServer resize, String serverId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)resize.getFlavorRef()) ? 1 : 0) != 0, (Object)"parameter `flavorRef` should not be empty");
        return this.post(AsyncRespEntity.class, "/cloudservers/" + serverId + "/resize").entity(resize).execute();
    }
}

