/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.evs.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.common.AsyncJobEntity;
import com.huawei.openstack4j.openstack.evs.v2.domain.CloudVolumes;
import com.huawei.openstack4j.openstack.evs.v2.domain.CloudVolumesResponse;
import com.huawei.openstack4j.openstack.evs.v2.domain.Extend;
import com.huawei.openstack4j.openstack.evs.v2.internal.BaseElasticVolumeService;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.Map;

public class VolumeService
extends BaseElasticVolumeService {
    public String create(CloudVolumes volume) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)volume.getAvailabilityZone()) ? 1 : 0) != 0, (Object)"parameter `availabilityZone` should not be empty");
        Preconditions.checkArgument((volume.getVolumeType() != null ? 1 : 0) != 0, (Object)"parameter `volumeType` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudvolumes").entity(volume).execute().getId();
    }

    public String extend(Extend extend, String volumeId) {
        Preconditions.checkArgument((null != extend.getOsExtend().getNewSize() ? 1 : 0) != 0, (Object)"parameter `newSize` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudvolumes/" + volumeId + "/action").entity(extend).execute().getId();
    }

    public CloudVolumesResponse list() {
        return this.get(CloudVolumesResponse.class, this.uri("/cloudvolumes/detail", new Object[0])).execute();
    }

    public CloudVolumesResponse list(Map<String, Object> filteringParams) {
        this.processListParams(filteringParams, "ids");
        this.processListParams(filteringParams, "enterprise_project_ids");
        BaseOpenStackService.Invocation<CloudVolumesResponse> volumeInvocation = this.buildInvocation(filteringParams);
        return volumeInvocation.execute();
    }

    private BaseOpenStackService.Invocation<CloudVolumesResponse> buildInvocation(Map<String, Object> filteringParams) {
        BaseOpenStackService.Invocation<CloudVolumesResponse> volumeInvocation = this.get(CloudVolumesResponse.class, "/cloudvolumes/detail");
        if (filteringParams == null) {
            return volumeInvocation;
        }
        for (Map.Entry<String, Object> entry : filteringParams.entrySet()) {
            volumeInvocation = volumeInvocation.param(entry.getKey(), entry.getValue());
        }
        return volumeInvocation;
    }
}

