/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.fgs.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.fgs.v1.domain.FunctionMetadata;
import com.huawei.openstack4j.openstack.fgs.v1.internal.BaseFunctionGraphService;
import java.util.Map;

public class FunctionService
extends BaseFunctionGraphService {
    private final String urlFmt = "/fss/functions/%s";

    public FunctionMetadata.Functions listFunction(int marker, int maxItems) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(marker)) ? 1 : 0) != 0, (Object)"parameter `marker` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(maxItems)) ? 1 : 0) != 0, (Object)"parameter `maxItems` should not be empty");
        return this.get(FunctionMetadata.Functions.class, this.uri("/fss/functions", new Object[0])).param("marker", marker).param("maxitems", maxItems).execute();
    }

    public FunctionMetadata getFunctionMetadata(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fss/functions/%s/config";
        return this.get(FunctionMetadata.class, this.uri(url, functionUrn)).execute();
    }

    public FunctionMetadata getFunctionCode(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fss/functions/%s/code";
        return this.get(FunctionMetadata.class, this.uri(url, functionUrn)).execute();
    }

    public FunctionMetadata createFunction(FunctionMetadata functionMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getFuncName()) ? 1 : 0) != 0, (Object)"parameter `FuncName` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getPackageName()) ? 1 : 0) != 0, (Object)"parameter `Package` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getCodeType()) ? 1 : 0) != 0, (Object)"parameter `CodeType` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getHandler()) ? 1 : 0) != 0, (Object)"parameter `Handler` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getMemorySize())) ? 1 : 0) != 0, (Object)"parameter `MemorySize` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getRuntime()) ? 1 : 0) != 0, (Object)"parameter `Runtime` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getTimeout())) ? 1 : 0) != 0, (Object)"parameter `Timeout` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getFuncCode().getFile()) ? 1 : 0) != 0, (Object)"parameter `FuncCode.File` should not be empty");
        return this.post(FunctionMetadata.class, "/fss/functions").entity(functionMetadata).execute();
    }

    public ActionResponse deleteFunction(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        return this.deleteWithResponse(this.uri("/fss/functions/%s", functionUrn)).execute();
    }

    public FunctionMetadata updateFunctionCode(String functionUrn, FunctionMetadata functionMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getCodeType()) ? 1 : 0) != 0, (Object)"parameter `CodeType` should not be empty");
        String url = "/fss/functions/%s/code";
        return this.put(FunctionMetadata.class, this.uri(url, functionUrn)).entity(functionMetadata).execute();
    }

    public FunctionMetadata updateFunctionConfig(String functionUrn, FunctionMetadata functionMetadata) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((functionMetadata.getStrategyConfig() != null ? 1 : 0) != 0, (Object)"parameter `StrategyConfig` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getStrategyConfig().getConcurrency())) ? 1 : 0) != 0, (Object)"parameter `StrategyConfig.Concurrency` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getHandler()) ? 1 : 0) != 0, (Object)"parameter `Handler` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(functionMetadata.getMemorySize())) ? 1 : 0) != 0, (Object)"parameter `MemorySize` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionMetadata.getRuntime()) ? 1 : 0) != 0, (Object)"parameter `Runtime` should not be empty");
        String url = "/fss/functions/%s/config";
        return this.put(FunctionMetadata.class, this.uri(url, functionUrn)).entity(functionMetadata).execute();
    }

    public String invokeFunction(String functionUrn, Map<?, ?> data) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fss/functions/%s/invocations";
        return this.post(String.class, this.uri(url, functionUrn)).entity(data).execute();
    }

    public String asyncInvokeFunction(String functionUrn, Map<?, ?> data) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fss/functions/%s/invocations-async";
        return this.post(String.class, this.uri(url, functionUrn)).entity(data).execute();
    }
}

