/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.fgs.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.fgs.v1.domain.FunctionTrigger;
import com.huawei.openstack4j.openstack.fgs.v1.internal.BaseFunctionGraphService;

public class TriggerService
extends BaseFunctionGraphService {
    private final String triggersUrlFmt = "/fss/triggers/%s";

    public FunctionTrigger[] listTriggersForFunction(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        return this.get(FunctionTrigger[].class, this.uri("/fss/triggers/%s", functionUrn)).execute();
    }

    public FunctionTrigger createTriggerInstance(String functionUrn, FunctionTrigger functionTriggers) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionTriggers.getTriggerTypeCode()) ? 1 : 0) != 0, (Object)"parameter `TriggerTypeCode` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionTriggers.getEventTypeCode()) ? 1 : 0) != 0, (Object)"parameter `EventTypeCode` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionTriggers.getEventData().toString()) ? 1 : 0) != 0, (Object)"parameter `EventData` should not be empty");
        return this.post(FunctionTrigger.class, this.uri("/fss/triggers/%s", functionUrn)).entity(functionTriggers).execute();
    }

    public ActionResponse deleteTrigger(String functionUrn, String trigger_type_code, String trigger_id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)trigger_type_code) ? 1 : 0) != 0, (Object)"parameter `trigger_type_code` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)trigger_id) ? 1 : 0) != 0, (Object)"parameter `trigger_id` should not be empty");
        String url = "/fss/triggers/%s/%s/%s";
        return this.deleteWithResponse(this.uri(url, functionUrn, trigger_type_code, trigger_id)).execute();
    }

    public FunctionTrigger getTriggerInstance(String functionUrn, String trigger_type_code, String trigger_id) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)trigger_type_code) ? 1 : 0) != 0, (Object)"parameter `trigger_type_code` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)trigger_id) ? 1 : 0) != 0, (Object)"parameter `trigger_id` should not be empty");
        String url = "/fss/triggers/%s/%s/%s";
        return this.get(FunctionTrigger.class, this.uri(url, functionUrn, trigger_type_code, trigger_id)).execute();
    }

    public ActionResponse deleteAllTriggersForFunction(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        return this.deleteWithResponse(this.uri("/fss/triggers/%s", functionUrn)).execute();
    }
}

