/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.fgs.v1.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.fgs.v1.domain.FunctionMetadata;
import com.huawei.openstack4j.openstack.fgs.v1.domain.FunctionVersionAlias;
import com.huawei.openstack4j.openstack.fgs.v1.internal.BaseFunctionGraphService;

public class VersionsService
extends BaseFunctionGraphService {
    private final String urlFmt = "/fss/functions/%s";

    public FunctionMetadata publishVersion(String functionUrn, FunctionMetadata fmd) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fss/functions/%s/versions";
        return this.post(FunctionMetadata.class, this.uri(url, functionUrn)).entity(fmd).execute();
    }

    public FunctionMetadata.FunctionVersions listFunctionVersions(String functionUrn, int marker, int maxItems) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(marker)) ? 1 : 0) != 0, (Object)"parameter `marker` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)Integer.toString(maxItems)) ? 1 : 0) != 0, (Object)"parameter `maxItems` should not be empty");
        String url = "/fss/functions/%s/versions";
        return this.get(FunctionMetadata.FunctionVersions.class, this.uri(url, functionUrn)).param("marker", marker).param("maxitems", maxItems).execute();
    }

    public FunctionVersionAlias createVersionAlias(String functionUrn, FunctionVersionAlias functionVersionAlias) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionVersionAlias.getName()) ? 1 : 0) != 0, (Object)"parameter `Name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionVersionAlias.getVersion()) ? 1 : 0) != 0, (Object)"parameter `Version` should not be empty");
        String url = "/fss/functions/%s/aliases";
        return this.post(FunctionVersionAlias.class, this.uri(url, functionUrn)).entity(functionVersionAlias).execute();
    }

    public FunctionVersionAlias updateVersionAlias(String functionUrn, FunctionVersionAlias functionVersionAlias) {
        String aliasName = functionVersionAlias.getName();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)aliasName) ? 1 : 0) != 0, (Object)"parameter `Name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionVersionAlias.getVersion()) ? 1 : 0) != 0, (Object)"parameter `Version` should not be empty");
        String url = "/fss/functions/%s/aliases/%s";
        return this.put(FunctionVersionAlias.class, this.uri(url, functionUrn, aliasName)).entity(functionVersionAlias).execute();
    }

    public ActionResponse deleteVersionAlias(String functionUrn, String alias_name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)alias_name) ? 1 : 0) != 0, (Object)"parameter `alias_name` should not be empty");
        String url = "/fss/functions/%s/aliases/%s";
        return this.deleteWithResponse(this.uri(url, functionUrn, alias_name)).execute();
    }

    public FunctionVersionAlias getVersionAlias(String functionUrn, String alias_name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)alias_name) ? 1 : 0) != 0, (Object)"parameter `alias_name` should not be empty");
        String url = "/fss/functions/%s/aliases/%s";
        return this.get(FunctionVersionAlias.class, this.uri(url, functionUrn, alias_name)).execute();
    }

    public FunctionVersionAlias[] listVersionAlias(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fss/functions/%s/aliases";
        return this.get(FunctionVersionAlias[].class, this.uri(url, functionUrn)).execute();
    }
}

