/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.fgs.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.fgs.v2.domain.FunctionTrigger;
import com.huawei.openstack4j.openstack.fgs.v2.internal.BaseFunctionGraphV2Service;

public class TriggerV2Service
extends BaseFunctionGraphV2Service {
    private final String triggersUrlFmt = "/fgs/triggers/%s";

    public FunctionTrigger[] listTriggersForFunction(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        return this.get(FunctionTrigger[].class, this.uri("/fgs/triggers/%s", functionUrn)).execute();
    }

    public FunctionTrigger createTriggerInstance(String functionUrn, FunctionTrigger functionTriggers) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionTriggers.getTriggerTypeCode()) ? 1 : 0) != 0, (Object)"parameter `TriggerTypeCode` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionTriggers.getEventTypeCode()) ? 1 : 0) != 0, (Object)"parameter `EventTypeCode` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionTriggers.getEventData().toString()) ? 1 : 0) != 0, (Object)"parameter `EventData` should not be empty");
        return this.post(FunctionTrigger.class, this.uri("/fgs/triggers/%s", functionUrn)).entity(functionTriggers).execute();
    }

    public ActionResponse deleteTrigger(String functionUrn, String triggerTypeCode, String triggerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)triggerTypeCode) ? 1 : 0) != 0, (Object)"parameter `triggerTypeCode` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)triggerId) ? 1 : 0) != 0, (Object)"parameter `triggerId` should not be empty");
        String url = "/fgs/triggers/%s/%s/%s";
        return this.deleteWithResponse(this.uri(url, functionUrn, triggerTypeCode, triggerId)).execute();
    }

    public FunctionTrigger getTriggerInstance(String functionUrn, String triggerTypeCode, String triggerId) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)triggerTypeCode) ? 1 : 0) != 0, (Object)"parameter `triggerTypeCode` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)triggerId) ? 1 : 0) != 0, (Object)"parameter `triggerId` should not be empty");
        String url = "/fgs/triggers/%s/%s/%s";
        return this.get(FunctionTrigger.class, this.uri(url, functionUrn, triggerTypeCode, triggerId)).execute();
    }

    public ActionResponse deleteAllTriggersForFunction(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/triggers/" + functionUrn;
        return this.deleteWithResponse(this.uri("/fgs/triggers/%s", functionUrn)).execute();
    }
}

