/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.fgs.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.openstack.fgs.v2.domain.FunctionVersionAlias;
import com.huawei.openstack4j.openstack.fgs.v2.internal.BaseFunctionGraphV2Service;

public class VersionsV2Service
extends BaseFunctionGraphV2Service {
    private final String urlFmt = "/fgs/functions/%s";

    public FunctionVersionAlias createVersionAlias(String functionUrn, FunctionVersionAlias functionVersionAlias) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionVersionAlias.getName()) ? 1 : 0) != 0, (Object)"parameter `Name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionVersionAlias.getVersion()) ? 1 : 0) != 0, (Object)"parameter `Version` should not be empty");
        String url = "/fgs/functions/%s/aliases";
        return this.post(FunctionVersionAlias.class, this.uri(url, functionUrn)).entity(functionVersionAlias).execute();
    }

    public FunctionVersionAlias updateVersionAlias(String functionUrn, FunctionVersionAlias functionVersionAlias) {
        String aliasName = functionVersionAlias.getName();
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)aliasName) ? 1 : 0) != 0, (Object)"parameter `Name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionVersionAlias.getVersion()) ? 1 : 0) != 0, (Object)"parameter `Version` should not be empty");
        String url = "/fgs/functions/%s/aliases/%s";
        return this.put(FunctionVersionAlias.class, this.uri(url, functionUrn, aliasName)).entity(functionVersionAlias).execute();
    }

    public ActionResponse deleteVersionAlias(String functionUrn, String aliasName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)aliasName) ? 1 : 0) != 0, (Object)"parameter `alias_name` should not be empty");
        String url = "/fgs/functions/%s/aliases/%s";
        return this.deleteWithResponse(this.uri(url, functionUrn, aliasName)).execute();
    }

    public FunctionVersionAlias getVersionAlias(String functionUrn, String aliasName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)aliasName) ? 1 : 0) != 0, (Object)"parameter `alias_name` should not be empty");
        String url = "/fgs/functions/%s/aliases/%s";
        return this.get(FunctionVersionAlias.class, this.uri(url, functionUrn, aliasName)).execute();
    }

    public FunctionVersionAlias[] listVersionAlias(String functionUrn) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)functionUrn) ? 1 : 0) != 0, (Object)"parameter `functionUrn` should not be empty");
        String url = "/fgs/functions/%s/aliases";
        return this.get(FunctionVersionAlias[].class, this.uri(url, functionUrn)).execute();
    }
}

