/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.gbp.domain;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.huawei.openstack4j.model.gbp.PolicyRule;
import com.huawei.openstack4j.model.gbp.builder.PolicyRuleBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.util.List;

@JsonRootName(value="policy_rule")
public class GbpPolicyRule
implements PolicyRule {
    private static final long serialVersionUID = 1L;
    private String name;
    @JsonProperty(value="tenant_id")
    private String tenantId;
    private String id;
    private String description;
    @JsonProperty(value="policy_classifier_id")
    private String policyClassifierId;
    @JsonProperty(value="policy_actions")
    private List<String> policyActions;
    private Boolean shared;
    private Boolean enabled;

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("desription", (Object)this.description).add("tenantId", (Object)this.tenantId).add("policyClassifierId", (Object)this.policyClassifierId).add("policyActions", this.policyActions).add("shared", (Object)this.shared).add("enabled", (Object)this.enabled).toString();
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPolicyClassifierId() {
        return this.policyClassifierId;
    }

    @Override
    public List<String> getPolicyActions() {
        return this.policyActions;
    }

    @Override
    public boolean isShared() {
        return this.shared == null ? false : this.shared;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled == null ? false : this.shared;
    }

    @Override
    public PolicyRuleBuilder toBuilder() {
        return new PolicyRuleConcreteBuilder(this);
    }

    public static PolicyRuleBuilder builder() {
        return new PolicyRuleConcreteBuilder();
    }

    public static class PolicyRuleConcreteBuilder
    implements PolicyRuleBuilder {
        private GbpPolicyRule policyRule;

        public PolicyRuleConcreteBuilder(GbpPolicyRule gbpPolicyRule) {
            this.policyRule = gbpPolicyRule;
        }

        public PolicyRuleConcreteBuilder() {
            this(new GbpPolicyRule());
        }

        @Override
        public PolicyRule build() {
            return this.policyRule;
        }

        @Override
        public PolicyRuleBuilder from(PolicyRule in) {
            this.policyRule = (GbpPolicyRule)in;
            return this;
        }

        @Override
        public PolicyRuleBuilder name(String name) {
            this.policyRule.name = name;
            return this;
        }

        @Override
        public PolicyRuleBuilder description(String description) {
            this.policyRule.description = description;
            return this;
        }

        @Override
        public PolicyRuleBuilder shared(boolean shared) {
            this.policyRule.shared = shared;
            return this;
        }

        @Override
        public PolicyRuleBuilder classifier(String classifierId) {
            this.policyRule.policyClassifierId = classifierId;
            return this;
        }

        @Override
        public PolicyRuleBuilder actions(List<String> actionIds) {
            this.policyRule.policyActions = actionIds;
            return this;
        }
    }

    public static class PolicyRules
    extends ListResult<GbpPolicyRule> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="policy_rules")
        private List<GbpPolicyRule> policyRules;

        @Override
        protected List<GbpPolicyRule> value() {
            return this.policyRules;
        }
    }
}

