/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.gbp.ExternalPolicyService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.gbp.ExternalPolicy;
import com.huawei.openstack4j.model.gbp.ExternalPolicyCreate;
import com.huawei.openstack4j.openstack.gbp.domain.GbpExternalPolicy;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class ExternalPolicyServiceImpl
extends BaseNetworkingServices
implements ExternalPolicyService {
    @Override
    public List<? extends ExternalPolicy> list() {
        return this.get(GbpExternalPolicy.ExternalPolicies.class, this.uri("/grouppolicy/external_policies", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends ExternalPolicy> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpExternalPolicy.ExternalPolicies> externalPolicyInvocation = this.buildInvocation(filteringParams);
        return externalPolicyInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpExternalPolicy.ExternalPolicies> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpExternalPolicy.ExternalPolicies> externalPolicyInvocation = this.get(GbpExternalPolicy.ExternalPolicies.class, "/grouppolicy/external_policies");
        if (filteringParams == null) {
            return externalPolicyInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                externalPolicyInvocation = externalPolicyInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return externalPolicyInvocation;
    }

    @Override
    public ExternalPolicy get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(GbpExternalPolicy.class, this.uri("/grouppolicy/external_policies/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/grouppolicy/external_policies/%s", id)).execute();
    }

    @Override
    public ExternalPolicy create(ExternalPolicyCreate externalPolicy) {
        return this.post(GbpExternalPolicy.class, this.uri("/grouppolicy/external_policies", new Object[0])).entity(externalPolicy).execute();
    }

    @Override
    public ExternalPolicy update(String externalPolicyId, ExternalPolicyCreate externalPolicy) {
        Preconditions.checkNotNull((Object)externalPolicyId);
        Preconditions.checkNotNull((Object)externalPolicy);
        return this.put(GbpExternalPolicy.class, this.uri("/grouppolicy/external_policies/%s", externalPolicyId)).entity(externalPolicy).execute();
    }
}

