/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.gbp.GroupService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.gbp.PolicyTargetGroup;
import com.huawei.openstack4j.model.gbp.PolicyTargetGroupCreate;
import com.huawei.openstack4j.openstack.gbp.domain.GbpPolicyTargetGroup;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class GroupServiceImpl
extends BaseNetworkingServices
implements GroupService {
    @Override
    public List<? extends PolicyTargetGroup> list() {
        return this.get(GbpPolicyTargetGroup.PolicyTargetGroups.class, this.uri("/grouppolicy/policy_target_groups", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends PolicyTargetGroup> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyTargetGroup.PolicyTargetGroups> policyTargetGroupInvocation = this.buildInvocation(filteringParams);
        return policyTargetGroupInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpPolicyTargetGroup.PolicyTargetGroups> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpPolicyTargetGroup.PolicyTargetGroups> policyTargetGroupInvocation = this.get(GbpPolicyTargetGroup.PolicyTargetGroups.class, "/grouppolicy/policy_target_groups");
        if (filteringParams == null) {
            return policyTargetGroupInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                policyTargetGroupInvocation = policyTargetGroupInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return policyTargetGroupInvocation;
    }

    @Override
    public PolicyTargetGroup get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(GbpPolicyTargetGroup.class, this.uri("/grouppolicy/policy_target_groups/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/grouppolicy/policy_target_groups/%s", id)).execute();
    }

    @Override
    public PolicyTargetGroup create(PolicyTargetGroupCreate policyTargetGroup) {
        return this.post(GbpPolicyTargetGroup.class, this.uri("/grouppolicy/policy_target_groups", new Object[0])).entity(policyTargetGroup).execute();
    }

    @Override
    public PolicyTargetGroup update(String policyTargetGroupId, PolicyTargetGroupCreate policyTargetGroup) {
        Preconditions.checkNotNull((Object)policyTargetGroupId);
        Preconditions.checkNotNull((Object)policyTargetGroup);
        return this.put(GbpPolicyTargetGroup.class, this.uri("/grouppolicy/policy_target_groups/%s", policyTargetGroupId)).entity(policyTargetGroup).execute();
    }
}

