/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.gbp.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.gbp.NatPoolService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.gbp.NatPool;
import com.huawei.openstack4j.openstack.gbp.domain.GbpNatPool;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import com.huawei.openstack4j.openstack.networking.internal.BaseNetworkingServices;
import java.util.List;
import java.util.Map;

public class NatPoolServiceImpl
extends BaseNetworkingServices
implements NatPoolService {
    @Override
    public List<? extends NatPool> list() {
        return this.get(GbpNatPool.NatPools.class, this.uri("/grouppolicy/nat_pools", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends NatPool> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpNatPool.NatPools> natpoolInvocation = this.buildInvocation(filteringParams);
        return natpoolInvocation.execute().getList();
    }

    private BaseOpenStackService.Invocation<GbpNatPool.NatPools> buildInvocation(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<GbpNatPool.NatPools> natpoolInvocation = this.get(GbpNatPool.NatPools.class, "/grouppolicy/nat_pools");
        if (filteringParams == null) {
            return natpoolInvocation;
        }
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                natpoolInvocation = natpoolInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return natpoolInvocation;
    }

    @Override
    public NatPool get(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.get(GbpNatPool.class, this.uri("/grouppolicy/nat_pools/%s", id)).execute();
    }

    @Override
    public ActionResponse delete(String id) {
        Preconditions.checkNotNull((Object)id);
        return this.deleteWithResponse(this.uri("/grouppolicy/nat_pools/%s", id)).execute();
    }

    @Override
    public NatPool create(NatPool natpool) {
        return this.post(GbpNatPool.class, this.uri("/grouppolicy/nat_pools", new Object[0])).entity(natpool).execute();
    }

    @Override
    public NatPool update(String natpoolId, NatPool natpool) {
        Preconditions.checkNotNull((Object)natpoolId);
        Preconditions.checkNotNull((Object)natpool);
        return this.put(GbpNatPool.class, this.uri("/grouppolicy/nat_pools/%s", natpoolId)).entity(natpool).execute();
    }
}

