/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.heat.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.heat.SoftwareConfigService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.heat.SoftwareConfig;
import com.huawei.openstack4j.openstack.heat.domain.HeatSoftwareConfig;
import com.huawei.openstack4j.openstack.heat.internal.BaseHeatServices;

public class SoftwareConfigServiceImpl
extends BaseHeatServices
implements SoftwareConfigService {
    private static final String BASE_URI = "/software_configs";

    @Override
    public SoftwareConfig create(SoftwareConfig sc) {
        Preconditions.checkNotNull((Object)sc);
        return this.post(HeatSoftwareConfig.class, BASE_URI).entity(sc).execute();
    }

    @Override
    public SoftwareConfig show(String configId) {
        Preconditions.checkNotNull((Object)configId);
        return this.get(HeatSoftwareConfig.class, this.uri("/software_configs/%s", configId)).execute();
    }

    @Override
    public ActionResponse delete(String configId) {
        Preconditions.checkNotNull((Object)configId);
        return this.deleteWithResponse(this.uri("/software_configs/%s", configId)).execute();
    }
}

