/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.iam.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import com.huawei.openstack4j.openstack.iam.domain.AuthDomain;
import com.huawei.openstack4j.openstack.iam.domain.AuthProject;
import java.beans.ConstructorProperties;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="scope")
public class AuthScope
implements ModelEntity {
    private static final long serialVersionUID = -5363065099764958747L;
    private AuthProject project;
    private AuthDomain domain;

    public static AuthScopeBuilder builder() {
        return new AuthScopeBuilder();
    }

    public AuthScopeBuilder toBuilder() {
        return new AuthScopeBuilder().project(this.project).domain(this.domain);
    }

    public AuthProject getProject() {
        return this.project;
    }

    public AuthDomain getDomain() {
        return this.domain;
    }

    public String toString() {
        return "AuthScope(project=" + this.getProject() + ", domain=" + this.getDomain() + ")";
    }

    public AuthScope() {
    }

    @ConstructorProperties(value={"project", "domain"})
    public AuthScope(AuthProject project, AuthDomain domain) {
        this.project = project;
        this.domain = domain;
    }

    public static class AuthScopeBuilder {
        private AuthProject project;
        private AuthDomain domain;

        AuthScopeBuilder() {
        }

        public AuthScopeBuilder project(AuthProject project) {
            this.project = project;
            return this;
        }

        public AuthScopeBuilder domain(AuthDomain domain) {
            this.domain = domain;
            return this;
        }

        public AuthScope build() {
            return new AuthScope(this.project, this.domain);
        }

        public String toString() {
            return "AuthScope.AuthScopeBuilder(project=" + this.project + ", domain=" + this.domain + ")";
        }
    }
}

