/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.functions;

import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ServiceFunctions {
    private static final Pattern VERSION_PATTERN = Pattern.compile("(.*)v(\\d+)");
    public static final Function<String, String> TYPE_WITHOUT_VERSION = new Function<String, String>(){

        public String apply(String serviceType) {
            return (String)ServiceFunctions.matchForVersion(serviceType, false);
        }
    };
    public static final Function<String, Integer> VERSION_FROM_TYPE = new Function<String, Integer>(){

        public Integer apply(String serviceType) {
            return (Integer)ServiceFunctions.matchForVersion(serviceType, true);
        }
    };

    private static <T> T matchForVersion(String service, boolean returnVersion) {
        Matcher m = VERSION_PATTERN.matcher(service);
        if (m.matches()) {
            if (returnVersion) {
                return (T)Integer.valueOf(m.group(2));
            }
            return (T)m.group(1);
        }
        if (returnVersion) {
            return (T)Integer.valueOf(1);
        }
        return (T)service;
    }
}

