/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.internal;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.huawei.openstack4j.api.ServiceEndpointProvider;
import com.huawei.openstack4j.api.exceptions.OS4JException;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.core.transport.ObjectMapperSingleton;
import com.huawei.openstack4j.model.identity.URLResolverParams;
import com.huawei.openstack4j.openstack.identity.internal.AbstractEndpointURLResolver;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;

public class AKSKEndpointURLResolver
extends AbstractEndpointURLResolver {
    static String defaultServiceEndpointFile = "service_endpoint.json";
    ServiceEndpointProvider endpointProvider;

    public static AKSKEndpointURLResolver instance() {
        LocalFileServiceEndpointProvider defaultEndpointProvider = null;
        try {
            InputStream is = AKSKEndpointURLResolver.class.getClassLoader().getResourceAsStream(defaultServiceEndpointFile);
            defaultEndpointProvider = new LocalFileServiceEndpointProvider(is);
        }
        catch (NullPointerException e) {
            throw new OS4JException("defaultServiceEndpointFile can not be found");
        }
        return new AKSKEndpointURLResolver().withEndpointProvider(defaultEndpointProvider);
    }

    @Override
    public String resolve(URLResolverParams p) {
        String endpoint = null;
        if (p.getServiceEndpoints() != null && p.getServiceEndpoints().get((Object)p.type) != null) {
            endpoint = p.getServiceEndpoints().get((Object)p.type).getEndpointFor(p.perspective);
            if (p.projectId != null) {
                endpoint = endpoint.replace("$(tenant_id)s", p.projectId);
            }
        }
        if (endpoint == null) {
            endpoint = this.getEndpointProvider().getEndpoint(p.type, p.perspective);
            endpoint = endpoint.replace("%(domain)s", p.domain);
            endpoint = endpoint.replace("%(region)s", p.region);
            if (p.projectId != null) {
                endpoint = endpoint.replace("%(projectId)s", p.projectId);
            }
        }
        return endpoint;
    }

    public ServiceEndpointProvider getEndpointProvider() {
        return this.endpointProvider;
    }

    public AKSKEndpointURLResolver withEndpointProvider(ServiceEndpointProvider endpointProvider) {
        this.endpointProvider = endpointProvider;
        return this;
    }

    @Override
    public String findURLV2(URLResolverParams params) {
        return null;
    }

    @Override
    public String findURLV3(URLResolverParams params) {
        return null;
    }

    public static class LocalFileServiceEndpointProvider
    implements ServiceEndpointProvider {
        private HashMap<ServiceType, ServiceEndpointProvider.ServiceEndpoint> serviceEndpoints;

        public LocalFileServiceEndpointProvider(InputStream inputStream) {
            MapType typeRef = TypeFactory.defaultInstance().constructMapType(HashMap.class, ServiceType.class, ServiceEndpointProvider.ServiceEndpoint.class);
            try {
                this.serviceEndpoints = (HashMap)ObjectMapperSingleton.getContext(ServiceEndpointProvider.ServiceEndpoint.class).readValue(inputStream, (JavaType)typeRef);
            }
            catch (Exception e) {
                throw new RuntimeException("Could not parse service endpoint from input-stream", e);
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }

        @Override
        public String getEndpoint(ServiceType service) {
            return this.getEndpoint(service, Facing.PUBLIC);
        }

        @Override
        public String getEndpoint(ServiceType serviceType, Facing perspective) {
            return this.serviceEndpoints.get((Object)serviceType).getEndpointFor(perspective);
        }
    }
}

