/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.signer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.huawei.openstack4j.core.transport.HttpRequest;
import com.huawei.openstack4j.core.transport.ObjectMapperSingleton;
import com.huawei.openstack4j.utils.BinaryUtils;
import java.beans.ConstructorProperties;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SimpleTimeZone;
import java.util.TreeMap;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class AKSK {
    public static final String EMPTY_BODY_SHA256 = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
    public static final String ISO8601BasicFormat = "yyyyMMdd'T'HHmmss'Z'";
    public static final String DateStringFormat = "yyyyMMdd";
    protected static final SimpleDateFormat dateTimeFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
    protected static final SimpleDateFormat dateStampFormat = new SimpleDateFormat("yyyyMMdd");

    public static HashMap<String, String> sign(HttpRequest<?> request, Credential credential) {
        String[] split;
        Date now = new Date();
        HashMap<String, String> authenticationHeaders = new HashMap<String, String>();
        String endpoint = request.getEndpoint();
        String requestPath = request.getPath();
        URL url = AKSK.convertToURL(endpoint, requestPath);
        String host = AKSK.buildCanonicalHost(url);
        authenticationHeaders.put("Host", host);
        dateTimeFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        dateStampFormat.setTimeZone(new SimpleTimeZone(0, "UTC"));
        String dateTimeStamp = dateTimeFormat.format(now);
        String datestamp = dateStampFormat.format(now);
        authenticationHeaders.put("X-Sdk-Date", dateTimeStamp);
        String pathOld = url.getPath();
        String path = "";
        for (String urlSplit : split = pathOld.split("/")) {
            path = path + "/" + AKSK.urlEncode(urlSplit);
        }
        if (path.length() > 0) {
            path = path.substring(1, path.length());
        }
        String canonicalURI = path.endsWith("/") ? path : path + "/";
        String query = url.getQuery();
        Map<String, List<Object>> parameters = request.getQueryParams();
        String canonicalQueryString = AKSK.buildCanonicalQueryString(query, parameters);
        String signedHeaderNames = Joiner.on((String)";").join(Constants.TO_SIGNED_HEADERS).toLowerCase();
        String canonicalHeaders = AKSK.buildCanonicalHeaders(authenticationHeaders);
        String payloadHash = AKSK.buildPayloadHash(request);
        String canonicalRequest = AKSK.buildCanonicalRequest(request.getMethod().name(), canonicalURI, canonicalQueryString, canonicalHeaders, signedHeaderNames, payloadHash);
        String canonicalRequestHash = BinaryUtils.toHex(AKSK.sha256(canonicalRequest));
        Object[] scopeArray = new String[]{datestamp, request.getRegion(), request.getService().getServiceName(), "sdk_request"};
        String credentialScope = Joiner.on((String)"/").join(scopeArray);
        String stringToSign = AKSK.getStringToSign("SDK-HMAC-SHA256", dateTimeStamp, credentialScope, canonicalRequestHash);
        String signatureString = AKSK.signature(request.getService().getServiceName(), datestamp, request.getRegion(), stringToSign, credential.getSk());
        StringBuilder authorization = new StringBuilder("SDK-HMAC-SHA256").append(" ");
        authorization.append("Credential=").append(credential.getAk()).append("/").append(credentialScope).append(", ");
        authorization.append("SignedHeaders=").append(signedHeaderNames).append(", ");
        authorization.append("Signature=").append(signatureString);
        authenticationHeaders.put("Authorization", authorization.toString());
        return authenticationHeaders;
    }

    public static String buildPayloadHash(HttpRequest<?> request) {
        if (!Strings.isNullOrEmpty((String)request.getJson())) {
            return BinaryUtils.toHex(AKSK.sha256(request.getJson()));
        }
        try {
            if (request.getEntity() != null) {
                Object entity = request.getEntity();
                String payload = ObjectMapperSingleton.getContext(entity.getClass()).writeValueAsString(entity);
                return BinaryUtils.toHex(AKSK.sha256(payload));
            }
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Could not serialize entity", e);
        }
        return EMPTY_BODY_SHA256;
    }

    public static URL convertToURL(String endpoint, String requestPath) {
        try {
            return new URL(endpoint + requestPath);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Endpoint illegal", e);
        }
    }

    public static String signature(String serviceName, String datestamp, String region, String stringToSign, String secretKey) {
        try {
            byte[] keySecret = ("SDK" + secretKey).getBytes("UTF-8");
            byte[] kDate = AKSK.hmac(keySecret, datestamp);
            byte[] kRegion = AKSK.hmac(kDate, region);
            byte[] kService = AKSK.hmac(kRegion, serviceName);
            byte[] kSigning = AKSK.hmac(kService, "sdk_request");
            byte[] signature = AKSK.hmac(kSigning, stringToSign);
            return BinaryUtils.toHex(signature);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getStringToSign(String ... segments) {
        return Joiner.on((String)"\n").join((Object[])segments);
    }

    private static String buildCanonicalRequest(String ... segments) {
        return Joiner.on((String)"\n").join((Object[])segments);
    }

    private static String buildCanonicalHeaders(HashMap<String, String> authenticationHeaders) {
        StringBuilder sb = new StringBuilder();
        for (String sortedKey : Constants.TO_SIGNED_HEADERS) {
            sb.append(sortedKey.toLowerCase()).append(":").append(authenticationHeaders.get(sortedKey));
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String buildCanonicalHost(URL url) {
        String host = url.getHost();
        int port = url.getPort();
        if (port > -1) {
            host.concat(":" + Integer.toString(port));
        }
        return host;
    }

    public static String buildCanonicalQueryString(String query, Map<String, List<Object>> parameters) {
        TreeMap<String, String> sorted = new TreeMap<String, String>();
        if (query != null && !query.isEmpty()) {
            String[] splitted;
            for (String split : splitted = query.split("&")) {
                String[] kv = split.split("=");
                if (kv.length != 2) continue;
                sorted.put(AKSK.urlEncode(kv[0]), AKSK.urlEncode(kv[1]));
            }
        }
        if (parameters != null && !parameters.isEmpty()) {
            for (Map.Entry<String, List<Object>> pair : parameters.entrySet()) {
                String key = pair.getKey();
                List<Object> values = pair.getValue();
                for (Object value : values) {
                    String valueString = value.toString();
                    if (("tags".equals(key) || "metadata".equals(key)) && (valueString.contains("%7B") || valueString.contains("%7D") || valueString.contains("%7b") || valueString.contains("%7d"))) {
                        valueString = valueString.replace("%7B", "{").replace("%7b", "{").replace("%7D", "}").replace("%7d", "}");
                    }
                    sorted.put(AKSK.urlEncode(key), AKSK.urlEncode(valueString));
                }
            }
        }
        StringBuilder builder = new StringBuilder();
        Iterator itr = sorted.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry pair = itr.next();
            builder.append((String)pair.getKey());
            builder.append("=");
            builder.append((String)pair.getValue());
            if (!itr.hasNext()) continue;
            builder.append("&");
        }
        return builder.toString();
    }

    public static String urlEncode(String url) {
        try {
            return URLEncoder.encode(url, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not supported.", e);
        }
    }

    public static byte[] sha256(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(text.getBytes("UTF-8"));
            byte[] bytes = md.digest();
            return bytes;
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to compute hash while signing request: " + e.getMessage(), e);
        }
    }

    protected static byte[] hmac(byte[] key, String data) {
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secretKeySpec = new SecretKeySpec(key, "HmacSHA256");
            hmac.init(secretKeySpec);
            return hmac.doFinal(data.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to calculate a request signature: " + e.getMessage(), e);
        }
    }

    public static void main(String[] args) {
        System.out.println(BinaryUtils.toHex(AKSK.sha256("")));
    }

    static {
        System.setProperty("sun.net.http.allowRestrictedHeaders", "true");
    }

    public static class Credential {
        String ak;
        String sk;

        @ConstructorProperties(value={"ak", "sk"})
        Credential(String ak, String sk) {
            this.ak = ak;
            this.sk = sk;
        }

        public static CredentialBuilder builder() {
            return new CredentialBuilder();
        }

        public String getAk() {
            return this.ak;
        }

        public String getSk() {
            return this.sk;
        }

        public void setAk(String ak) {
            this.ak = ak;
        }

        public void setSk(String sk) {
            this.sk = sk;
        }

        public static class CredentialBuilder {
            private String ak;
            private String sk;

            CredentialBuilder() {
            }

            public CredentialBuilder ak(String ak) {
                this.ak = ak;
                return this;
            }

            public CredentialBuilder sk(String sk) {
                this.sk = sk;
                return this;
            }

            public Credential build() {
                return new Credential(this.ak, this.sk);
            }

            public String toString() {
                return "AKSK.Credential.CredentialBuilder(ak=" + this.ak + ", sk=" + this.sk + ")";
            }
        }
    }

    public static class Constants {
        public static final String LINE_SEPARATOR = "\n";
        public static final String SDK_NAME = "SDK";
        public static final String SDK_TERMINATOR = "sdk_request";
        public static final String SDK_SIGNING_ALGORITHM = "SDK-HMAC-SHA256";
        public static final String X_SDK_DATE = "X-Sdk-Date";
        public static final String X_SDK_CONTENT_SHA256 = "x-sdk-content-sha256";
        public static final String AUTHORIZATION = "Authorization";
        public static final String HOST = "Host";
        public static final String CONTENT_TYPE = "Content-Type";
        public static final String CONTENT_LENGTH = "Content-Length";
        public static final List<String> TO_SIGNED_HEADERS = Lists.newArrayList((Object[])new String[]{"Host", "X-Sdk-Date"});
    }
}

