/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.identity.AuthStore;
import com.huawei.openstack4j.model.identity.AuthVersion;
import com.huawei.openstack4j.openstack.common.Auth;
import com.huawei.openstack4j.openstack.identity.v2.domain.Auth;
import java.io.Serializable;

@JsonRootName(value="auth")
public class Credentials
extends Auth
implements AuthStore {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="passwordCredentials")
    private PasswordCredentials passwordCreds = new PasswordCredentials();

    public Credentials() {
        super(Auth.Type.CREDENTIALS);
    }

    public Credentials(String username, String password) {
        this();
        this.passwordCreds.setCredentials(username, password);
    }

    public Credentials(String username, String password, String tenantName) {
        this();
        this.passwordCreds.setCredentials(username, password);
        this.setTenantName(tenantName);
    }

    public Credentials(String username, String password, String tenantName, String tenantId) {
        this();
        this.passwordCreds.setCredentials(username, password);
        this.setTenantName(tenantName);
        this.setTenantId(tenantId);
    }

    @Override
    @JsonIgnore
    public String getUsername() {
        return this.passwordCreds.username;
    }

    @Override
    @JsonIgnore
    public String getPassword() {
        return this.passwordCreds.password;
    }

    @Override
    @JsonIgnore
    public String getId() {
        return this.getTenantId();
    }

    @Override
    @JsonIgnore
    public String getName() {
        return this.getTenantName();
    }

    @Override
    @JsonIgnore
    public AuthVersion getVersion() {
        return AuthVersion.V2;
    }

    private static final class PasswordCredentials
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @JsonProperty
        String username;
        @JsonProperty
        String password;

        private PasswordCredentials() {
        }

        public void setCredentials(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }
}

