/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v2.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.huawei.openstack4j.model.identity.v2.Endpoint;
import com.huawei.openstack4j.model.identity.v2.builder.EndpointBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.net.URI;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class KeystoneEndpoint
implements Endpoint {
    private static final long serialVersionUID = 1L;
    private String type;
    private String id;
    private String name;
    private String region;
    private URI publicURL;
    private URI internalURL;
    private URI adminURL;
    private String tenantId;
    private String versionId;
    private URI versionInfo;
    private URI versionList;

    public static EndpointBuilder builder() {
        return new EndPointConcreteBuilder();
    }

    @Override
    public EndpointBuilder toBuilder() {
        return new EndPointConcreteBuilder(this);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getAdminURL() {
        return this.adminURL;
    }

    @Override
    public URI getPublicURL() {
        return this.publicURL;
    }

    @Override
    public URI getInternalURL() {
        return this.internalURL;
    }

    @Override
    public String getRegion() {
        return this.region;
    }

    @Override
    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public String getVersionId() {
        return this.versionId;
    }

    @Override
    public URI getVersionInfo() {
        return this.versionInfo;
    }

    @Override
    public URI getVersionList() {
        return this.versionList;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.id, this.versionId, this.region, this.publicURL, this.internalURL, this.adminURL, this.versionInfo, this.versionList, this.tenantId, this.type});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneEndpoint that = (KeystoneEndpoint)KeystoneEndpoint.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.versionId, (Object)that.versionId) && Objects.equal((Object)this.region, (Object)that.region) && Objects.equal((Object)this.publicURL, (Object)that.publicURL) && Objects.equal((Object)this.internalURL, (Object)that.internalURL) && Objects.equal((Object)this.adminURL, (Object)that.adminURL) && Objects.equal((Object)this.versionInfo, (Object)that.versionInfo) && Objects.equal((Object)this.versionList, (Object)that.versionList) && Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal((Object)this.type, (Object)that.type);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("name", (Object)this.name).add("type", (Object)this.type).add("region", (Object)this.region).add("publicURL", (Object)this.publicURL).add("internalURL", (Object)this.internalURL).add("adminURL", (Object)this.adminURL).add("versionId", (Object)this.versionId).add("versionInfo", (Object)this.versionInfo).add("versionList", (Object)this.versionList).toString();
    }

    public static class EndPointConcreteBuilder
    implements EndpointBuilder {
        protected KeystoneEndpoint model;

        protected EndPointConcreteBuilder() {
            this(new KeystoneEndpoint());
        }

        EndPointConcreteBuilder(KeystoneEndpoint model) {
            this.model = model;
        }

        @Override
        public EndpointBuilder region(String region) {
            this.model.region = region;
            return this;
        }

        @Override
        public EndpointBuilder publicURL(URI publicURL) {
            this.model.publicURL = publicURL;
            return this;
        }

        @Override
        public EndpointBuilder internalURL(URI internalURL) {
            this.model.internalURL = internalURL;
            return this;
        }

        @Override
        public EndpointBuilder tenantId(String tenantId) {
            this.model.tenantId = tenantId;
            return this;
        }

        @Override
        public EndpointBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public EndpointBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public EndpointBuilder name(String name) {
            this.model.name = name;
            return this;
        }

        @Override
        public EndpointBuilder adminURL(URI adminURL) {
            this.model.adminURL = adminURL;
            return this;
        }

        @Override
        public EndpointBuilder versionInfo(URI versionInfo) {
            this.model.versionInfo = versionInfo;
            return this;
        }

        @Override
        public EndpointBuilder versionList(URI versionList) {
            this.model.versionList = versionList;
            return this;
        }

        @Override
        public KeystoneEndpoint build() {
            return this.model;
        }

        @Override
        public EndpointBuilder from(Endpoint in) {
            this.model = (KeystoneEndpoint)in;
            return this;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class Endpoints
    extends ListResult<KeystoneEndpoint> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="endpoints")
        private List<KeystoneEndpoint> endpoints;

        @Override
        public List<KeystoneEndpoint> value() {
            return this.endpoints;
        }
    }
}

