/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v2.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v2.ServiceManagerService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v2.Service;
import com.huawei.openstack4j.model.identity.v2.ServiceEndpoint;
import com.huawei.openstack4j.openstack.identity.v2.domain.KeystoneService;
import com.huawei.openstack4j.openstack.identity.v2.domain.KeystoneServiceEndpoint;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class ServiceManagerServiceImpl
extends BaseOpenStackService
implements ServiceManagerService {
    @Override
    public List<? extends Service> list() {
        return this.get(KeystoneService.Services.class, this.uri("/OS-KSADM/services", new Object[0])).execute().getList();
    }

    @Override
    public Service get(String serviceId) {
        Preconditions.checkNotNull((Object)serviceId);
        return this.get(KeystoneService.class, this.uri("/OS-KSADM/services/%s", serviceId)).execute();
    }

    @Override
    public Service create(String name, String type, String description) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)description);
        return this.post(KeystoneService.class, this.uri("/OS-KSADM/services", new Object[0])).entity(KeystoneService.builder().name(name).type(type).description(description).build()).execute();
    }

    @Override
    public ActionResponse delete(String serviceId) {
        Preconditions.checkNotNull((Object)serviceId);
        return this.deleteWithResponse(this.uri("/OS-KSADM/services/%s", serviceId)).execute();
    }

    @Override
    public List<? extends ServiceEndpoint> listEndpoints() {
        return this.get(KeystoneServiceEndpoint.ServiceEndpoints.class, this.uri("/endpoints", new Object[0])).execute().getList();
    }

    @Override
    public ServiceEndpoint createEndpoint(String region, String serviceId, String publicURL, String adminURL, String internalURL) {
        Preconditions.checkNotNull((Object)region);
        Preconditions.checkNotNull((Object)serviceId);
        Preconditions.checkNotNull((Object)publicURL);
        Preconditions.checkNotNull((Object)adminURL);
        Preconditions.checkNotNull((Object)internalURL);
        return this.post(KeystoneServiceEndpoint.class, this.uri("/endpoints", new Object[0])).entity(KeystoneServiceEndpoint.builder().region(region).serviceId(serviceId).publicURL(publicURL).adminURL(adminURL).internalURL(internalURL).build()).execute();
    }

    @Override
    public ActionResponse deleteEndpoint(String endpointId) {
        Preconditions.checkNotNull((Object)endpointId);
        return this.deleteWithResponse(this.uri("/endpoints/%s", endpointId)).execute();
    }
}

