/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v2.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.identity.v2.UserService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v2.Role;
import com.huawei.openstack4j.model.identity.v2.User;
import com.huawei.openstack4j.openstack.identity.v2.domain.KeystoneUser;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class UserServiceImpl
extends BaseOpenStackService
implements UserService {
    @Override
    public List<? extends User> list() {
        return this.get(KeystoneUser.Users.class, this.uri("/users", new Object[0])).execute().getList();
    }

    @Override
    public User get(String userId) {
        Preconditions.checkNotNull((Object)userId);
        return this.get(KeystoneUser.class, this.uri("/users/%s", userId)).execute();
    }

    @Override
    public List<? extends User> listTenantUsers(String tenantId) {
        Preconditions.checkNotNull((Object)tenantId);
        return this.get(KeystoneUser.Users.class, this.uri("/tenants/%s/users", tenantId)).execute().getList();
    }

    @Override
    public User create(String tenantId, String name, String password, String email, boolean enabled) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)password);
        return this.create((User)KeystoneUser.builder().name(name).tenantId(tenantId).email(email).password(password).enabled(enabled).build());
    }

    @Override
    public User create(User user) {
        Preconditions.checkNotNull((Object)user);
        return this.post(KeystoneUser.class, this.uri("/users", new Object[0])).entity(user).execute();
    }

    @Override
    public ActionResponse delete(String userId) {
        Preconditions.checkNotNull((Object)userId);
        return this.deleteWithResponse(this.uri("/users/%s", userId)).execute();
    }

    @Override
    public User enableUser(String userId, boolean enabled) {
        Preconditions.checkNotNull((Object)userId);
        return this.put(KeystoneUser.class, this.uri("/users/%s/OS-KSADM/enabled", userId)).entity(KeystoneUser.builder().enabled(enabled).build()).execute();
    }

    @Override
    public User update(User user) {
        Preconditions.checkNotNull((Object)user);
        return this.put(KeystoneUser.class, this.uri("/users/%s", user.getId())).entity(user).execute();
    }

    @Override
    public ActionResponse changePassword(String userId, String password) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)password);
        return this.put(ActionResponse.class, this.uri("/users/%s/OS-KSADM/password", userId)).entity(KeystoneUser.builder().id(userId).password(password).build()).execute();
    }

    @Override
    public List<? extends Role> listRoles(String userId) {
        Preconditions.checkNotNull((Object)userId);
        return Apis.getIdentityV2Services().roles().listRolesForUser(userId);
    }

    @Override
    public List<? extends Role> listRoles(User user) {
        Preconditions.checkNotNull((Object)user);
        return this.listRoles(user.getId());
    }

    @Override
    public List<? extends Role> listRolesOnTenant(String userId, String tenantId) {
        return Apis.getIdentityV2Services().roles().listRolesForUser(userId, tenantId);
    }

    @Override
    public List<? extends Role> listRolesOnCurrentTenant(User user) {
        Preconditions.checkNotNull((Object)user);
        return Apis.getIdentityV2Services().roles().listRolesForUser(user.getId(), user.getTenantId());
    }

    @Override
    public User getByName(String userName) {
        Preconditions.checkNotNull((Object)userName);
        return this.get(KeystoneUser.class, "/users").param("name", userName).execute();
    }
}

