/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.huawei.openstack4j.model.identity.v3.Region;
import com.huawei.openstack4j.model.identity.v3.builder.RegionBuilder;
import com.huawei.openstack4j.openstack.common.ListResult;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="region")
public class KeystoneRegion
implements Region {
    private static final long serialVersionUID = 1L;
    private String id;
    private String description;
    @JsonProperty(value="parent_region_id")
    private String parentRegionId;
    private Map<String, String> links;
    private String type;
    private Map<String, String> locales;

    public static RegionBuilder builder() {
        return new RegionConcreteBuilder();
    }

    @Override
    public RegionBuilder toBuilder() {
        return new RegionConcreteBuilder(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getParentRegionId() {
        return this.parentRegionId;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getLinks() {
        return this.links;
    }

    public void setLinks(Map<String, String> links) {
        this.links = links;
    }

    @Override
    public Map<String, String> getLocales() {
        return this.locales;
    }

    public void setLocales(Map<String, String> locales) {
        this.locales = locales;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.id).add("description", (Object)this.description).add("parentRegionId", (Object)this.parentRegionId).add("type", (Object)this.type).add("links", this.links).add("locales", this.locales).toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        KeystoneRegion that = (KeystoneRegion)KeystoneRegion.class.cast(obj);
        return Objects.equal((Object)this.id, (Object)that.id) && Objects.equal((Object)this.description, (Object)that.description) && Objects.equal((Object)this.parentRegionId, (Object)that.parentRegionId) && Objects.equal(this.links, that.links) && Objects.equal((Object)this.type, (Object)that.type) && Objects.equal(this.locales, that.locales);
    }

    public static class RegionConcreteBuilder
    implements RegionBuilder {
        KeystoneRegion model;

        RegionConcreteBuilder() {
            this(new KeystoneRegion());
        }

        RegionConcreteBuilder(KeystoneRegion model) {
            this.model = model;
        }

        @Override
        public RegionBuilder id(String id) {
            this.model.id = id;
            return this;
        }

        @Override
        public Region build() {
            return this.model;
        }

        @Override
        public RegionBuilder from(Region in) {
            if (in != null) {
                this.model = (KeystoneRegion)in;
            }
            return this;
        }

        @Override
        public RegionBuilder description(String description) {
            this.model.description = description;
            return this;
        }

        @Override
        public RegionBuilder parentRegionId(String parentRegionId) {
            this.model.parentRegionId = parentRegionId;
            return this;
        }

        @Override
        public RegionBuilder type(String type) {
            this.model.type = type;
            return this;
        }

        @Override
        public RegionBuilder links(Map<String, String> links) {
            this.model.links = links;
            return this;
        }

        @Override
        public RegionBuilder locales(Map<String, String> locales) {
            this.model.locales = locales;
            return this;
        }
    }

    public static class Regions
    extends ListResult<KeystoneRegion> {
        private static final long serialVersionUID = 1L;
        @JsonProperty(value="regions")
        private List<KeystoneRegion> list;

        @Override
        public List<KeystoneRegion> value() {
            return this.list;
        }
    }
}

