/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.domain;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.huawei.openstack4j.model.ModelEntity;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonRootName(value="version")
public class Version
implements ModelEntity {
    private static final long serialVersionUID = 8730146983228887835L;
    private String status;
    private Date updated;
    @JsonProperty(value="media-types")
    private List<Map<String, String>> mediaTypes;
    private String id;
    private List<Map<String, String>> links;

    public static VersionBuilder builder() {
        return new VersionBuilder();
    }

    public VersionBuilder toBuilder() {
        return new VersionBuilder().status(this.status).updated(this.updated).mediaTypes(this.mediaTypes).id(this.id).links(this.links);
    }

    public String getStatus() {
        return this.status;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public List<Map<String, String>> getMediaTypes() {
        return this.mediaTypes;
    }

    public String getId() {
        return this.id;
    }

    public List<Map<String, String>> getLinks() {
        return this.links;
    }

    public String toString() {
        return "Version(status=" + this.getStatus() + ", updated=" + this.getUpdated() + ", mediaTypes=" + this.getMediaTypes() + ", id=" + this.getId() + ", links=" + this.getLinks() + ")";
    }

    public Version() {
    }

    @ConstructorProperties(value={"status", "updated", "mediaTypes", "id", "links"})
    public Version(String status, Date updated, List<Map<String, String>> mediaTypes, String id, List<Map<String, String>> links) {
        this.status = status;
        this.updated = updated;
        this.mediaTypes = mediaTypes;
        this.id = id;
        this.links = links;
    }

    public static class VersionBuilder {
        private String status;
        private Date updated;
        private List<Map<String, String>> mediaTypes;
        private String id;
        private List<Map<String, String>> links;

        VersionBuilder() {
        }

        public VersionBuilder status(String status) {
            this.status = status;
            return this;
        }

        public VersionBuilder updated(Date updated) {
            this.updated = updated;
            return this;
        }

        public VersionBuilder mediaTypes(List<Map<String, String>> mediaTypes) {
            this.mediaTypes = mediaTypes;
            return this;
        }

        public VersionBuilder id(String id) {
            this.id = id;
            return this;
        }

        public VersionBuilder links(List<Map<String, String>> links) {
            this.links = links;
            return this;
        }

        public Version build() {
            return new Version(this.status, this.updated, this.mediaTypes, this.id, this.links);
        }

        public String toString() {
            return "Version.VersionBuilder(status=" + this.status + ", updated=" + this.updated + ", mediaTypes=" + this.mediaTypes + ", id=" + this.id + ", links=" + this.links + ")";
        }
    }
}

