/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v3.GroupService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Group;
import com.huawei.openstack4j.model.identity.v3.Role;
import com.huawei.openstack4j.model.identity.v3.User;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneGroup;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneRole;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneUser;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class GroupServiceImpl
extends BaseOpenStackService
implements GroupService {
    @Override
    public Group get(String groupId) {
        Preconditions.checkNotNull((Object)groupId);
        return this.get(KeystoneGroup.class, "/groups", "/", groupId).execute();
    }

    @Override
    public List<? extends Group> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<KeystoneGroup.Groups> flavorInvocation = this.get(KeystoneGroup.Groups.class, this.uri("/groups", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    @Override
    public List<? extends Group> getByName(String groupName) {
        return this.get(KeystoneGroup.Groups.class, this.uri("/groups", new Object[0])).param("name", groupName).execute().getList();
    }

    @Override
    public Group getByName(String groupName, String domainId) {
        Preconditions.checkNotNull((Object)groupName);
        Preconditions.checkNotNull((Object)domainId);
        return (Group)this.get(KeystoneGroup.Groups.class, this.uri("/groups", new Object[0])).param("name", groupName).param("domain_id", domainId).execute().first();
    }

    @Override
    public ActionResponse delete(String groupId) {
        Preconditions.checkNotNull((Object)groupId);
        return this.deleteWithResponse("/groups", "/", groupId).execute();
    }

    @Override
    public Group update(Group group) {
        Preconditions.checkNotNull((Object)group);
        return this.patch(KeystoneGroup.class, "/groups", "/", group.getId()).entity(group).execute();
    }

    @Override
    public Group create(Group group) {
        Preconditions.checkNotNull((Object)group);
        return this.post(KeystoneGroup.class, this.uri("/groups", new Object[0])).entity(group).execute();
    }

    @Override
    public Group create(String domainId, String name, String description) {
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)description);
        return this.create((Group)KeystoneGroup.builder().domainId(domainId).name(name).description(description).build());
    }

    @Override
    public List<? extends Group> list() {
        return this.get(KeystoneGroup.Groups.class, this.uri("/groups", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends User> listGroupUsers(String groupId) {
        Preconditions.checkNotNull((Object)groupId);
        return this.get(KeystoneUser.Users.class, this.uri("/groups/%s/users", groupId)).execute().getList();
    }

    @Override
    public List<? extends User> listGroupUsers(String groupId, Map<String, String> filteringParams) {
        Preconditions.checkNotNull((Object)groupId);
        BaseOpenStackService.Invocation<KeystoneUser.Users> flavorInvocation = this.get(KeystoneUser.Users.class, this.uri("/groups/%s/users", groupId));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    @Override
    public ActionResponse checkGroupUser(String groupId, String userId) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)userId);
        return this.head(ActionResponse.class, this.uri("/groups/%s/users/%s", groupId, userId)).execute();
    }

    @Override
    public ActionResponse addUserToGroup(String groupId, String userId) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)userId);
        return this.put(ActionResponse.class, this.uri("groups/%s/users/%s", groupId, userId)).execute();
    }

    @Override
    public ActionResponse removeUserFromGroup(String groupId, String userId) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)userId);
        return this.deleteWithResponse(this.uri("groups/%s/users/%s", groupId, userId)).execute();
    }

    @Override
    public List<? extends Role> listProjectGroupRoles(String groupId, String projectId) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)projectId);
        return this.get(KeystoneRole.Roles.class, this.uri("projects/%s/groups/%s/roles", projectId, groupId)).execute().getList();
    }

    @Override
    public List<? extends Role> listDomainGroupRoles(String groupId, String domainId) {
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)domainId);
        return this.get(KeystoneRole.Roles.class, this.uri("domains/%s/groups/%s/roles", domainId, groupId)).execute().getList();
    }
}

