/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v3.RoleService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Role;
import com.huawei.openstack4j.model.identity.v3.RoleAssignment;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneRole;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneRoleAssignment;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class RoleServiceImpl
extends BaseOpenStackService
implements RoleService {
    @Override
    public ActionResponse grantProjectUserRole(String projectId, String userId, String roleId) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)roleId);
        return this.put(ActionResponse.class, this.uri("projects/%s/users/%s/roles/%s", projectId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeProjectUserRole(String projectId, String userId, String roleId) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)roleId);
        return this.deleteWithResponse(this.uri("projects/%s/users/%s/roles/%s", projectId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse checkProjectUserRole(String projectId, String userId, String roleId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)roleId);
        return this.head(ActionResponse.class, this.uri("/projects/%s/users/%s/roles/%s", projectId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse grantDomainUserRole(String domainId, String userId, String roleId) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)roleId);
        return this.put(ActionResponse.class, this.uri("domains/%s/users/%s/roles/%s", domainId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeDomainUserRole(String domainId, String userId, String roleId) {
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)roleId);
        return this.deleteWithResponse(this.uri("domains/%s/users/%s/roles/%s", domainId, userId, roleId)).execute();
    }

    @Override
    public ActionResponse checkDomainUserRole(String domainId, String userId, String roleId) {
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)userId);
        Preconditions.checkNotNull((Object)roleId);
        return this.head(ActionResponse.class, this.uri("/domains/%s/users/%s/roles/%s", domainId, userId, roleId)).execute();
    }

    @Override
    public List<? extends Role> list() {
        return this.get(KeystoneRole.Roles.class, this.uri("/roles", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Role> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<KeystoneRole.Roles> flavorInvocation = this.get(KeystoneRole.Roles.class, this.uri("/roles", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    @Override
    public List<? extends Role> getByName(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.get(KeystoneRole.Roles.class, "/roles").param("name", name).execute().getList();
    }

    @Override
    public Role create(Role role) {
        Preconditions.checkNotNull((Object)role);
        return this.post(KeystoneRole.class, this.uri("/roles", new Object[0])).entity(role).execute();
    }

    @Override
    public Role create(String name) {
        Preconditions.checkNotNull((Object)name);
        return this.create((Role)KeystoneRole.builder().name(name).build());
    }

    @Override
    public Role update(Role role) {
        Preconditions.checkNotNull((Object)role);
        return this.patch(KeystoneRole.class, "/roles", "/", role.getId()).entity(role).execute();
    }

    @Override
    public ActionResponse delete(String roleId) {
        Preconditions.checkNotNull((Object)roleId);
        return this.deleteWithResponse("/roles", "/", roleId).execute();
    }

    @Override
    public Role get(String roleId) {
        Preconditions.checkNotNull((Object)roleId);
        return this.get(KeystoneRole.class, "/roles", "/", roleId).execute();
    }

    @Override
    public List<? extends RoleAssignment> listRoleAssignments(String projectId) {
        Preconditions.checkNotNull((Object)projectId);
        return this.get(KeystoneRoleAssignment.RoleAssignments.class, "role_assignments").param("scope.project.id", projectId).param("effective", "true").execute().getList();
    }

    @Override
    public ActionResponse grantProjectGroupRole(String projectId, String groupId, String roleId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)roleId);
        return this.put(ActionResponse.class, this.uri("projects/%s/groups/%s/roles/%s", projectId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeProjectGroupRole(String projectId, String groupId, String roleId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)roleId);
        return this.deleteWithResponse(this.uri("projects/%s/groups/%s/roles/%s", projectId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse checkProjectGroupRole(String projectId, String groupId, String roleId) {
        Preconditions.checkNotNull((Object)projectId);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)roleId);
        return this.head(ActionResponse.class, this.uri("/projects/%s/groups/%s/roles/%s", projectId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse grantDomainGroupRole(String domainId, String groupId, String roleId) {
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)roleId);
        return this.put(ActionResponse.class, this.uri("domains/%s/groups/%s/roles/%s", domainId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse revokeDomainGroupRole(String domainId, String groupId, String roleId) {
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)roleId);
        return this.deleteWithResponse(this.uri("domains/%s/groups/%s/roles/%s", domainId, groupId, roleId)).execute();
    }

    @Override
    public ActionResponse checkDomainGroupRole(String domainId, String groupId, String roleId) {
        Preconditions.checkNotNull((Object)domainId);
        Preconditions.checkNotNull((Object)groupId);
        Preconditions.checkNotNull((Object)roleId);
        return this.head(ActionResponse.class, this.uri("/domains/%s/groups/%s/roles/%s", domainId, groupId, roleId)).execute();
    }
}

