/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v3.ServiceEndpointService;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Endpoint;
import com.huawei.openstack4j.model.identity.v3.Service;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneEndpoint;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneService;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.net.URL;
import java.util.List;
import java.util.Map;

public class ServiceEndpointServiceImpl
extends BaseOpenStackService
implements ServiceEndpointService {
    @Override
    public Service create(Service service) {
        Preconditions.checkNotNull((Object)service);
        return this.post(KeystoneService.class, this.uri("/services", new Object[0])).entity(service).execute();
    }

    @Override
    public Service create(String type, String name, String description, boolean enabled) {
        Preconditions.checkNotNull((Object)type);
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)description);
        Preconditions.checkNotNull((Object)enabled);
        return this.create((Service)KeystoneService.builder().type(type).name(name).description(description).enabled(enabled).build());
    }

    @Override
    public Service get(String serviceId) {
        Preconditions.checkNotNull((Object)serviceId);
        return this.get(KeystoneService.class, "/services", "/", serviceId).execute();
    }

    @Override
    public Service update(Service service) {
        Preconditions.checkNotNull((Object)service);
        return this.patch(KeystoneService.class, "/services", "/", service.getId()).entity(service).execute();
    }

    @Override
    public ActionResponse delete(String serviceId) {
        Preconditions.checkNotNull((Object)serviceId);
        return this.deleteWithResponse("/services", "/", serviceId).execute();
    }

    @Override
    public List<? extends Service> list() {
        return this.get(KeystoneService.Services.class, this.uri("/services", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Service> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<KeystoneService.Services> flavorInvocation = this.get(KeystoneService.Services.class, this.uri("/services", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    @Override
    public List<? extends Endpoint> listEndpoints() {
        return this.get(KeystoneEndpoint.Endpoints.class, this.uri("/endpoints", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Endpoint> listEndpoints(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<KeystoneEndpoint.Endpoints> flavorInvocation = this.get(KeystoneEndpoint.Endpoints.class, this.uri("/endpoints", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                flavorInvocation = flavorInvocation.param(entry.getKey(), entry.getValue());
            }
        }
        return flavorInvocation.execute().getList();
    }

    @Override
    public Endpoint createEndpoint(Endpoint endpoint) {
        Preconditions.checkNotNull((Object)endpoint);
        return this.post(KeystoneEndpoint.class, this.uri("/endpoints", new Object[0])).entity(endpoint).execute();
    }

    @Override
    public Endpoint createEndpoint(String name, URL url, Facing iface, String regionId, String serviceId, boolean enabled) {
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull((Object)url);
        Preconditions.checkNotNull((Object)((Object)iface));
        Preconditions.checkNotNull((Object)regionId);
        Preconditions.checkNotNull((Object)serviceId);
        Preconditions.checkNotNull((Object)enabled);
        return this.createEndpoint((Endpoint)KeystoneEndpoint.builder().name(name).url(url).iface(iface).regionId(regionId).serviceId(serviceId).enabled(enabled).build());
    }

    @Override
    public Endpoint getEndpoint(String endpointId) {
        Preconditions.checkNotNull((Object)endpointId);
        return this.get(KeystoneEndpoint.class, "/endpoints", "/", endpointId).execute();
    }

    @Override
    public Endpoint updateEndpoint(Endpoint endpoint) {
        Preconditions.checkNotNull((Object)endpoint);
        return this.patch(KeystoneEndpoint.class, "/endpoints", "/", endpoint.getId()).entity(endpoint).execute();
    }

    @Override
    public ActionResponse deleteEndpoint(String endpointId) {
        Preconditions.checkNotNull((Object)endpointId);
        return this.deleteWithResponse("/endpoints", "/", endpointId).execute();
    }
}

