/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.identity.v3.internal;

import com.google.common.base.Preconditions;
import com.huawei.openstack4j.api.identity.v3.TokenService;
import com.huawei.openstack4j.model.common.ActionResponse;
import com.huawei.openstack4j.model.identity.v3.Domain;
import com.huawei.openstack4j.model.identity.v3.Project;
import com.huawei.openstack4j.model.identity.v3.Service;
import com.huawei.openstack4j.model.identity.v3.Token;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneDomain;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneService;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneToken;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;

public class TokenServiceImpl
extends BaseOpenStackService
implements TokenService {
    @Override
    public Token get(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneToken.class, "/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public ActionResponse check(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.head(ActionResponse.class, "/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public ActionResponse delete(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.deleteWithResponse("/auth/tokens").header("X-Subject-Token", tokenId).execute();
    }

    @Override
    public List<? extends Service> getServiceCatalog(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneService.Catalog.class, this.uri("auth/catalog", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Project> getProjectScopes(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneProject.Projects.class, this.uri("auth/projects", new Object[0])).execute().getList();
    }

    @Override
    public List<? extends Domain> getDomainScopes(String tokenId) {
        Preconditions.checkNotNull((Object)tokenId);
        return this.get(KeystoneDomain.Domains.class, this.uri("auth/domains", new Object[0])).execute().getList();
    }
}

