/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.ims.v2.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.huawei.openstack4j.openstack.common.AsyncJobEntity;
import com.huawei.openstack4j.openstack.ims.v2.domain.DataImage;
import com.huawei.openstack4j.openstack.ims.v2.domain.Image;
import com.huawei.openstack4j.openstack.ims.v2.domain.ImageCreateByExternalImage;
import com.huawei.openstack4j.openstack.ims.v2.domain.ImageCreateByInstance;
import com.huawei.openstack4j.openstack.ims.v2.domain.ImageCreateByQuickImport;
import com.huawei.openstack4j.openstack.ims.v2.domain.ImageUpdate;
import com.huawei.openstack4j.openstack.ims.v2.internal.BaseImageManagementService;
import com.huawei.openstack4j.openstack.internal.BaseOpenStackService;
import java.util.List;
import java.util.Map;

public class ImageService
extends BaseImageManagementService {
    public String create(ImageCreateByInstance imageCreateByInstance) {
        if (null != imageCreateByInstance.getDataImages() && imageCreateByInstance.getDataImages().size() > 0) {
            Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)imageCreateByInstance.getInstanceId()), (Object)"parameter `instanceId` should be empty");
            for (DataImage data : imageCreateByInstance.getDataImages()) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)data.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)data.getVolumeId()) ? 1 : 0) != 0, (Object)"parameter `volumeId` should not be empty");
            }
        } else {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByInstance.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByInstance.getInstanceId()) ? 1 : 0) != 0, (Object)"parameter `instanceId` should not be empty");
        }
        return this.post(AsyncJobEntity.class, "/cloudimages/action").entity(imageCreateByInstance).execute().getId();
    }

    public String create(ImageCreateByExternalImage imageCreateByExternalImage) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByExternalImage.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByExternalImage.getImageUrl()) ? 1 : 0) != 0, (Object)"parameter `imageUrl` should not be empty");
        Preconditions.checkArgument((null != imageCreateByExternalImage.getMinDisk() ? 1 : 0) != 0, (Object)"parameter `minDisk` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudimages/action").entity(imageCreateByExternalImage).execute().getId();
    }

    public String create(ImageCreateByQuickImport imageCreateByQuickImport) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByQuickImport.getName()) ? 1 : 0) != 0, (Object)"parameter `name` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByQuickImport.getImageUrl()) ? 1 : 0) != 0, (Object)"parameter `imageUrl` should not be empty");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageCreateByQuickImport.getType()) ? 1 : 0) != 0, (Object)"parameter `type` should not be empty");
        Preconditions.checkArgument((null != imageCreateByQuickImport.getMinDisk() ? 1 : 0) != 0, (Object)"parameter `minDisk` should not be empty");
        return this.post(AsyncJobEntity.class, "/cloudimages/quickimport/action").entity(imageCreateByQuickImport).execute().getId();
    }

    public List<Image> list(Map<String, String> filteringParams) {
        BaseOpenStackService.Invocation<Image.Images> req = this.get(Image.Images.class, this.uri("/cloudimages", new Object[0]));
        if (filteringParams != null) {
            for (Map.Entry<String, String> entry : filteringParams.entrySet()) {
                req = req.param(entry.getKey(), entry.getValue());
            }
        }
        return req.execute().getList();
    }

    public List<Image> list() {
        return this.get(Image.Images.class, this.uri("/cloudimages", new Object[0])).execute().getList();
    }

    public Image update(List<ImageUpdate> updateModel, String imageId) {
        Preconditions.checkArgument((!updateModel.isEmpty() ? 1 : 0) != 0, (Object)"parameter `updateModel` should not be null");
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)imageId) ? 1 : 0) != 0, (Object)"parameter `imageId` should not be empty");
        return this.patch(Image.class, this.uri("/cloudimages/%s", imageId)).entity(updateModel).execute();
    }
}

