/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.openstack.internal;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.huawei.openstack4j.api.Apis;
import com.huawei.openstack4j.api.OSClient;
import com.huawei.openstack4j.api.client.CloudProvider;
import com.huawei.openstack4j.api.identity.EndpointURLResolver;
import com.huawei.openstack4j.api.identity.v3.IdentityService;
import com.huawei.openstack4j.api.loadbalance.ELBService;
import com.huawei.openstack4j.api.scaling.AutoScalingService;
import com.huawei.openstack4j.api.telemetry.TelemetryAodhService;
import com.huawei.openstack4j.api.telemetry.TelemetryService;
import com.huawei.openstack4j.api.types.Facing;
import com.huawei.openstack4j.api.types.ServiceType;
import com.huawei.openstack4j.core.transport.Config;
import com.huawei.openstack4j.model.common.Identifier;
import com.huawei.openstack4j.model.identity.AuthVersion;
import com.huawei.openstack4j.model.identity.URLResolverParams;
import com.huawei.openstack4j.model.identity.v3.Token;
import com.huawei.openstack4j.openstack.antiddos.internal.AntiDDoSServices;
import com.huawei.openstack4j.openstack.cloud.trace.v1.internal.CloudTraceV1Service;
import com.huawei.openstack4j.openstack.cloud.trace.v2.internal.CloudTraceV2Service;
import com.huawei.openstack4j.openstack.common.Auth;
import com.huawei.openstack4j.openstack.database.internal.DatabaseServices;
import com.huawei.openstack4j.openstack.iam.internal.IamService;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneAuth;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneProject;
import com.huawei.openstack4j.openstack.identity.v3.domain.KeystoneToken;
import com.huawei.openstack4j.openstack.identity.v3.functions.ServiceToServiceType;
import com.huawei.openstack4j.openstack.internal.OSAuthenticator;
import com.huawei.openstack4j.openstack.internal.OSClientSession;
import com.huawei.openstack4j.openstack.kms.internal.KeyManagementService;
import com.huawei.openstack4j.openstack.maas.internal.MaaSService;
import com.huawei.openstack4j.openstack.message.notification.internal.NotificationService;
import com.huawei.openstack4j.openstack.message.queue.internal.MessageQueueService;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.slf4j.LoggerFactory;

public class OSClientSessionV3
extends OSClientSession<OSClientSessionV3, OSClient.OSClientV3>
implements OSClient.OSClientV3 {
    protected KeystoneAuth.AuthScope scope;
    private String user;
    private String password;
    private Identifier domain;
    private String authUrl;
    private String projectId;
    public static final String HTTPS = "https";
    public static final String SEPARATOR = "/";
    public static final String POINT = ":";

    public OSClientSessionV3() {
    }

    public OSClientSessionV3(Token token, String endpoint, Facing perspective, CloudProvider provider, Config config) {
        this.token = token;
        this.config = config;
        this.perspective = perspective;
        this.provider = provider;
        sessions.set(this);
    }

    private OSClientSessionV3(Token token, OSClientSessionV3 parent, String region) {
        this.token = parent.token;
        this.perspective = parent.perspective;
        this.region = region;
    }

    public static OSClientSessionV3 createSession(Token token) {
        return new OSClientSessionV3(token, token.getEndpoint(), null, null, null);
    }

    public static OSClientSessionV3 createSession(Token token, Facing perspective, CloudProvider provider, Config config) {
        return new OSClientSessionV3(token, token.getEndpoint(), perspective, provider, config);
    }

    public String getXOpenstackRequestId() {
        return this.reqId;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    @Override
    public String getEndpoint() {
        return this.token.getEndpoint();
    }

    @Override
    public AuthVersion getAuthVersion() {
        return AuthVersion.V3;
    }

    private String addNATIfApplicable(String url) {
        if (this.config != null && this.config.isBehindNAT()) {
            try {
                URI uri = new URI(url);
                return url.replace(uri.getHost(), this.config.getEndpointNATResolution());
            }
            catch (URISyntaxException e) {
                LoggerFactory.getLogger(OSClientSessionV3.class).error(e.getMessage(), (Throwable)e);
            }
        }
        return url;
    }

    @Override
    public String getEndpoint(ServiceType service) {
        EndpointURLResolver eUrlResolver = this.config != null && this.config.getEndpointURLResolver() != null ? this.config.getEndpointURLResolver() : this.fallbackEndpointUrlResolver;
        return this.addNATIfApplicable(eUrlResolver.findURLV3(URLResolverParams.create(this.token, service).resolver(this.config != null ? this.config.getResolver() : null).perspective(this.perspective).region(this.region)));
    }

    @Override
    public String getTokenId() {
        return this.token.getId();
    }

    @Override
    public IdentityService identity() {
        return Apis.getIdentityV3Services();
    }

    @Override
    public Set<ServiceType> getSupportedServices() {
        if (this.supports == null) {
            this.supports = Sets.immutableEnumSet((Iterable)Iterables.transform(this.token.getCatalog(), (Function)new ServiceToServiceType()));
        }
        return this.supports;
    }

    @Override
    public TelemetryService telemetry() {
        return Apis.get(TelemetryAodhService.class);
    }

    @Override
    public OSClient.OSClientV3 scopeToProject(Identifier project) {
        this.scope = KeystoneAuth.AuthScope.project(project);
        return this;
    }

    @Override
    public OSClient.OSClientV3 withConfig(Config config) {
        this.config = config;
        return this;
    }

    @Override
    public OSClient.OSClientV3 credentials(String tokenId, String projectId) {
        KeystoneToken token = new KeystoneToken();
        token.setId(tokenId);
        KeystoneProject project = new KeystoneProject();
        project.setId(projectId);
        token.setProjectInfo(project);
        this.token = token;
        return this;
    }

    @Override
    public OSClient.OSClientV3 withProjectId(String projectId) {
        this.projectId = projectId;
        if (null != this.token) {
            KeystoneProject project = new KeystoneProject();
            project.setId(projectId);
            this.token.setProjectInfo(project);
        }
        return this;
    }

    @Override
    public OSClient.OSClientV3 withToken(String tokenId) {
        KeystoneToken token = new KeystoneToken();
        token.setId(tokenId);
        this.projectId = (String)this.getHeaders().get("X-Project-Id");
        if (this.projectId != null) {
            KeystoneProject project = new KeystoneProject();
            project.setId(this.projectId);
            token.setProjectInfo(project);
        }
        this.token = token;
        return this;
    }

    @Override
    public OSClient.OSClientV3 credentials(String user, String password, String domainId, String projectId, String authUrl) {
        return this.credentials(user, password, Identifier.byId(domainId), Identifier.byId(projectId), authUrl);
    }

    @Override
    public OSClient.OSClientV3 credentials(String user, String password, Identifier domain, Identifier project, String authUrl) {
        this.user = user;
        this.password = password;
        this.domain = domain;
        this.authUrl = authUrl;
        this.scope = KeystoneAuth.AuthScope.project(project);
        OSClient.OSClientV3 client = this.authenticate();
        this.token = client.getToken();
        KeystoneProject projectInfo = new KeystoneProject();
        projectInfo.setId(project.getId());
        this.token.setProjectInfo(projectInfo);
        return this;
    }

    public OSClient.OSClientV3 authenticate() {
        if (this.token != null && this.token.getId() != null && this.token.getId().length() > 0) {
            return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.token.getId(), this.scope), this.authUrl, this.perspective, this.config, this.provider);
        }
        if (this.user != null && this.user.length() > 0) {
            return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.user, this.password, this.domain, this.scope), this.authUrl, this.perspective, this.config, this.provider);
        }
        return (OSClient.OSClientV3)OSAuthenticator.invoke(new KeystoneAuth(this.scope, Auth.Type.TOKENLESS), this.authUrl, this.perspective, this.config, this.provider);
    }

    @Override
    public AutoScalingService autoScaling() {
        return Apis.get(AutoScalingService.class);
    }

    @Override
    public ELBService loadBalancer() {
        return Apis.get(ELBService.class);
    }

    @Override
    public CloudTraceV1Service cloudTraceV1() {
        return Apis.get(CloudTraceV1Service.class);
    }

    @Override
    public CloudTraceV2Service cloudTraceV2() {
        return Apis.get(CloudTraceV2Service.class);
    }

    @Override
    public AntiDDoSServices antiDDoS() {
        return Apis.get(AntiDDoSServices.class);
    }

    @Override
    public NotificationService notification() {
        return Apis.get(NotificationService.class);
    }

    @Override
    public MessageQueueService messageQueue() {
        return Apis.get(MessageQueueService.class);
    }

    @Override
    public MaaSService maas() {
        return Apis.get(MaaSService.class);
    }

    @Override
    public DatabaseServices database() {
        return Apis.get(DatabaseServices.class);
    }

    @Override
    public KeyManagementService keyManagement() {
        return Apis.get(KeyManagementService.class);
    }

    @Override
    public IamService iam() {
        return Apis.get(IamService.class);
    }
}

